"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file

Protocol Buffers describing the Expansion API, an api for expanding
transforms in a remote SDK.
"""
import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.message
import google.protobuf.struct_pb2
import org.apache.beam.model.pipeline.v1.beam_runner_api_pb2
import org.apache.beam.model.pipeline.v1.schema_pb2
import sys

if sys.version_info >= (3, 8):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing_extensions.final
class ExpansionRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class OutputCoderRequestsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        value: builtins.str
        def __init__(
            self,
            *,
            key: builtins.str | None = ...,
            value: builtins.str | None = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    COMPONENTS_FIELD_NUMBER: builtins.int
    TRANSFORM_FIELD_NUMBER: builtins.int
    NAMESPACE_FIELD_NUMBER: builtins.int
    OUTPUT_CODER_REQUESTS_FIELD_NUMBER: builtins.int
    REQUIREMENTS_FIELD_NUMBER: builtins.int
    PIPELINE_OPTIONS_FIELD_NUMBER: builtins.int
    @property
    def components(self) -> org.apache.beam.model.pipeline.v1.beam_runner_api_pb2.Components:
        """Set of components needed to interpret the transform, or which
        may be useful for its expansion.  This includes the input
        PCollections (if any) to the to-be-expanded transform, along
        with their coders and windowing strategies.
        """
    @property
    def transform(self) -> org.apache.beam.model.pipeline.v1.beam_runner_api_pb2.PTransform:
        """The actual PTransform to be expaneded according to its spec.
        Its input should be set, but its subtransforms and outputs
        should not be.
        """
    namespace: builtins.str
    """A namespace (prefix) to use for the id of any newly created
    components.
    """
    @property
    def output_coder_requests(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
        """(Optional) Map from a local output tag to a coder id.
        If it is set, asks the expansion service to use the given
        coders for the output PCollections. Note that the request
        may not be fulfilled.
        """
    @property
    def requirements(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """A set of requirements that must be used by the expansion service to
        interpret the components provided with this request.
        """
    @property
    def pipeline_options(self) -> google.protobuf.struct_pb2.Struct:
        """(Optional) A set of Pipeline Options that should be used
        when expanding this transform.
        """
    def __init__(
        self,
        *,
        components: org.apache.beam.model.pipeline.v1.beam_runner_api_pb2.Components | None = ...,
        transform: org.apache.beam.model.pipeline.v1.beam_runner_api_pb2.PTransform | None = ...,
        namespace: builtins.str | None = ...,
        output_coder_requests: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        requirements: collections.abc.Iterable[builtins.str] | None = ...,
        pipeline_options: google.protobuf.struct_pb2.Struct | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["components", b"components", "pipeline_options", b"pipeline_options", "transform", b"transform"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["components", b"components", "namespace", b"namespace", "output_coder_requests", b"output_coder_requests", "pipeline_options", b"pipeline_options", "requirements", b"requirements", "transform", b"transform"]) -> None: ...

global___ExpansionRequest = ExpansionRequest

@typing_extensions.final
class ExpansionResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    COMPONENTS_FIELD_NUMBER: builtins.int
    TRANSFORM_FIELD_NUMBER: builtins.int
    REQUIREMENTS_FIELD_NUMBER: builtins.int
    ERROR_FIELD_NUMBER: builtins.int
    @property
    def components(self) -> org.apache.beam.model.pipeline.v1.beam_runner_api_pb2.Components:
        """Set of components needed to execute the expanded transform,
        including the (original) inputs, outputs, and subtransforms.
        """
    @property
    def transform(self) -> org.apache.beam.model.pipeline.v1.beam_runner_api_pb2.PTransform:
        """The expanded transform itself, with references to its outputs
        and subtransforms.
        """
    @property
    def requirements(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """A set of requirements that must be appended to this pipeline's
        requirements.
        """
    error: builtins.str
    """(Optional) An string representation of any error encountered while
    attempting to expand this transform.
    """
    def __init__(
        self,
        *,
        components: org.apache.beam.model.pipeline.v1.beam_runner_api_pb2.Components | None = ...,
        transform: org.apache.beam.model.pipeline.v1.beam_runner_api_pb2.PTransform | None = ...,
        requirements: collections.abc.Iterable[builtins.str] | None = ...,
        error: builtins.str | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["components", b"components", "transform", b"transform"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["components", b"components", "error", b"error", "requirements", b"requirements", "transform", b"transform"]) -> None: ...

global___ExpansionResponse = ExpansionResponse

@typing_extensions.final
class DiscoverSchemaTransformRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___DiscoverSchemaTransformRequest = DiscoverSchemaTransformRequest

@typing_extensions.final
class SchemaTransformConfig(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CONFIG_SCHEMA_FIELD_NUMBER: builtins.int
    INPUT_PCOLLECTION_NAMES_FIELD_NUMBER: builtins.int
    OUTPUT_PCOLLECTION_NAMES_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    @property
    def config_schema(self) -> org.apache.beam.model.pipeline.v1.schema_pb2.Schema:
        """Config schema of the SchemaTransform"""
    @property
    def input_pcollection_names(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Names of input PCollections"""
    @property
    def output_pcollection_names(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """Names of output PCollections"""
    description: builtins.str
    """Description of this transform and usage used for documentation.
    May be markdown formatted.
    Note that configuration parameters may also have documentation attached
    as part of the config_schema.
    """
    def __init__(
        self,
        *,
        config_schema: org.apache.beam.model.pipeline.v1.schema_pb2.Schema | None = ...,
        input_pcollection_names: collections.abc.Iterable[builtins.str] | None = ...,
        output_pcollection_names: collections.abc.Iterable[builtins.str] | None = ...,
        description: builtins.str | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["config_schema", b"config_schema"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["config_schema", b"config_schema", "description", b"description", "input_pcollection_names", b"input_pcollection_names", "output_pcollection_names", b"output_pcollection_names"]) -> None: ...

global___SchemaTransformConfig = SchemaTransformConfig

@typing_extensions.final
class DiscoverSchemaTransformResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    @typing_extensions.final
    class SchemaTransformConfigsEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> global___SchemaTransformConfig: ...
        def __init__(
            self,
            *,
            key: builtins.str | None = ...,
            value: global___SchemaTransformConfig | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    SCHEMA_TRANSFORM_CONFIGS_FIELD_NUMBER: builtins.int
    ERROR_FIELD_NUMBER: builtins.int
    @property
    def schema_transform_configs(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, global___SchemaTransformConfig]:
        """A mapping from SchemaTransform ID to schema transform config of discovered
        SchemaTransforms
        """
    error: builtins.str
    """If list of identifies are empty, this may contain an error."""
    def __init__(
        self,
        *,
        schema_transform_configs: collections.abc.Mapping[builtins.str, global___SchemaTransformConfig] | None = ...,
        error: builtins.str | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["error", b"error", "schema_transform_configs", b"schema_transform_configs"]) -> None: ...

global___DiscoverSchemaTransformResponse = DiscoverSchemaTransformResponse
