/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.aggregation;

import java.io.IOException;
import org.apache.cassandra.db.ClusteringComparator;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.db.aggregation.GroupMaker;
import org.apache.cassandra.db.aggregation.GroupingState;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;

public abstract class AggregationSpecification {
    public static final Serializer serializer = new Serializer();
    public static final AggregationSpecification AGGREGATE_EVERYTHING = new AggregationSpecification(Kind.AGGREGATE_EVERYTHING){

        @Override
        public GroupMaker newGroupMaker(GroupingState state) {
            return GroupMaker.GROUP_EVERYTHING;
        }
    };
    private final Kind kind;

    public Kind kind() {
        return this.kind;
    }

    private AggregationSpecification(Kind kind) {
        this.kind = kind;
    }

    public final GroupMaker newGroupMaker() {
        return this.newGroupMaker(GroupingState.EMPTY_STATE);
    }

    public abstract GroupMaker newGroupMaker(GroupingState var1);

    public static AggregationSpecification aggregatePkPrefix(ClusteringComparator comparator, int clusteringPrefixSize) {
        return new AggregateByPkPrefix(comparator, clusteringPrefixSize);
    }

    public static class Serializer {
        public void serialize(AggregationSpecification aggregationSpec, DataOutputPlus out, int version) throws IOException {
            out.writeByte(aggregationSpec.kind().ordinal());
            switch (aggregationSpec.kind()) {
                case AGGREGATE_EVERYTHING: {
                    break;
                }
                case AGGREGATE_BY_PK_PREFIX: {
                    out.writeUnsignedVInt(((AggregateByPkPrefix)aggregationSpec).clusteringPrefixSize);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }

        public AggregationSpecification deserialize(DataInputPlus in, int version, ClusteringComparator comparator) throws IOException {
            Kind kind = Kind.values()[in.readUnsignedByte()];
            switch (kind) {
                case AGGREGATE_EVERYTHING: {
                    return AGGREGATE_EVERYTHING;
                }
                case AGGREGATE_BY_PK_PREFIX: {
                    int clusteringPrefixSize = (int)in.readUnsignedVInt();
                    return AggregationSpecification.aggregatePkPrefix(comparator, clusteringPrefixSize);
                }
            }
            throw new AssertionError();
        }

        public long serializedSize(AggregationSpecification aggregationSpec, int version) {
            long size = TypeSizes.sizeof((byte)aggregationSpec.kind().ordinal());
            switch (aggregationSpec.kind()) {
                case AGGREGATE_EVERYTHING: {
                    break;
                }
                case AGGREGATE_BY_PK_PREFIX: {
                    size += (long)TypeSizes.sizeofUnsignedVInt(((AggregateByPkPrefix)aggregationSpec).clusteringPrefixSize);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            return size;
        }
    }

    private static final class AggregateByPkPrefix
    extends AggregationSpecification {
        private final int clusteringPrefixSize;
        private final ClusteringComparator comparator;

        public AggregateByPkPrefix(ClusteringComparator comparator, int clusteringPrefixSize) {
            super(Kind.AGGREGATE_BY_PK_PREFIX);
            this.comparator = comparator;
            this.clusteringPrefixSize = clusteringPrefixSize;
        }

        @Override
        public GroupMaker newGroupMaker(GroupingState state) {
            return GroupMaker.newInstance(this.comparator, this.clusteringPrefixSize, state);
        }
    }

    public static enum Kind {
        AGGREGATE_EVERYTHING,
        AGGREGATE_BY_PK_PREFIX;

    }
}

