/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.openssl;

import java.nio.ByteBuffer;

final class OpenSSLServerHelloExplorer {
    private OpenSSLServerHelloExplorer() {
    }

    static int getCipherSuite(ByteBuffer input) {
        byte messageType = input.get();
        if (messageType != 22) {
            return -1;
        }
        byte helloMajorVersion = input.get();
        byte helloMinorVersion = input.get();
        int length = OpenSSLServerHelloExplorer.getInt16(input);
        byte handshakeType = input.get();
        if (handshakeType != 2) {
            return -1;
        }
        int handshakeLength = OpenSSLServerHelloExplorer.getInt24(input);
        int result = OpenSSLServerHelloExplorer.exploreServerHello(input);
        return result;
    }

    private static int exploreServerHello(ByteBuffer input) {
        byte helloMajorVersion = input.get();
        byte helloMinorVersion = input.get();
        for (int i = 0; i < 32; ++i) {
            input.get();
        }
        OpenSSLServerHelloExplorer.processByteVector8(input);
        return OpenSSLServerHelloExplorer.getInt16(input);
    }

    private static int getInt8(ByteBuffer input) {
        return input.get();
    }

    private static int getInt16(ByteBuffer input) {
        return (input.get() & 0xFF) << 8 | input.get() & 0xFF;
    }

    private static int getInt24(ByteBuffer input) {
        return (input.get() & 0xFF) << 16 | (input.get() & 0xFF) << 8 | input.get() & 0xFF;
    }

    private static void processByteVector8(ByteBuffer input) {
        int int8 = OpenSSLServerHelloExplorer.getInt8(input);
        OpenSSLServerHelloExplorer.processByteVector(input, int8);
    }

    private static void processByteVector(ByteBuffer input, int length) {
        for (int i = 0; i < length; ++i) {
            input.get();
        }
    }
}

