/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.catalog;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.gravitino.Audit;
import org.apache.gravitino.file.Fileset;
import org.apache.gravitino.meta.AuditInfo;
import org.apache.gravitino.meta.FilesetEntity;

public final class EntityCombinedFileset
implements Fileset {
    private final Fileset fileset;
    private final FilesetEntity filesetEntity;
    private Set<String> hiddenProperties = Collections.emptySet();

    private EntityCombinedFileset(Fileset fileset, FilesetEntity filesetEntity) {
        this.fileset = fileset;
        this.filesetEntity = filesetEntity;
    }

    public FilesetEntity filesetEntity() {
        return this.filesetEntity;
    }

    public Fileset fileset() {
        return this.fileset;
    }

    public static EntityCombinedFileset of(Fileset fileset, FilesetEntity filesetEntity) {
        return new EntityCombinedFileset(fileset, filesetEntity);
    }

    public static EntityCombinedFileset of(Fileset fileset) {
        return new EntityCombinedFileset(fileset, null);
    }

    public EntityCombinedFileset withHiddenProperties(Set<String> hiddenProperties) {
        this.hiddenProperties = hiddenProperties != null ? hiddenProperties : Collections.emptySet();
        return this;
    }

    public String name() {
        return this.fileset.name();
    }

    public String comment() {
        return this.fileset.comment();
    }

    public Fileset.Type type() {
        return this.fileset.type();
    }

    public Map<String, String> storageLocations() {
        return this.fileset.storageLocations();
    }

    public Map<String, String> properties() {
        return this.fileset.properties().entrySet().stream().filter(p -> !this.hiddenProperties.contains(p.getKey())).filter(entry -> entry.getKey() != null && entry.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public Audit auditInfo() {
        AuditInfo mergedAudit = AuditInfo.builder().withCreator(this.fileset.auditInfo().creator()).withCreateTime(this.fileset.auditInfo().createTime()).withLastModifier(this.fileset.auditInfo().lastModifier()).withLastModifiedTime(this.fileset.auditInfo().lastModifiedTime()).build();
        return this.filesetEntity == null ? this.fileset.auditInfo() : mergedAudit.merge(this.filesetEntity.auditInfo(), true);
    }
}

