/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.cli;

import java.util.Arrays;
import org.apache.commons.cli.CommandLine;
import org.apache.gravitino.cli.CommandContext;
import org.apache.gravitino.cli.CommandHandler;
import org.apache.gravitino.cli.FullName;
import org.apache.gravitino.cli.GravitinoCommandLine;
import org.apache.gravitino.cli.Main;
import org.apache.gravitino.cli.commands.Command;

public class TagCommandHandler
extends CommandHandler {
    private final GravitinoCommandLine gravitinoCommandLine;
    private final CommandLine line;
    private final String command;
    private final CommandContext context;
    private String[] tags;
    private String metalake;

    public TagCommandHandler(GravitinoCommandLine gravitinoCommandLine, CommandLine line, String command, CommandContext context) {
        this.gravitinoCommandLine = gravitinoCommandLine;
        this.line = line;
        this.command = command;
        this.context = context;
        this.tags = line.getOptionValues("tag");
        if (this.tags != null) {
            this.tags = (String[])Arrays.stream(this.tags).distinct().toArray(String[]::new);
        }
    }

    @Override
    public void handle() {
        String userName = this.line.getOptionValue("login");
        FullName name = new FullName(this.line);
        Command.setAuthenticationMode(this.context.auth(), userName);
        this.metalake = name.getMetalakeName();
        if (!this.executeCommand()) {
            System.err.println("Unsupported or unknown command.");
            Main.exit(-1);
        }
    }

    private boolean executeCommand() {
        switch (this.command) {
            case "details": {
                this.handleDetailsCommand();
                return true;
            }
            case "list": {
                this.handleListCommand();
                return true;
            }
            case "create": {
                this.handleCreateCommand();
                return true;
            }
            case "delete": {
                this.handleDeleteCommand();
                return true;
            }
            case "set": {
                this.handleSetCommand();
                return true;
            }
            case "remove": {
                this.handleRemoveCommand();
                return true;
            }
            case "properties": {
                this.handlePropertiesCommand();
                return true;
            }
            case "update": {
                this.handleUpdateCommand();
                return true;
            }
        }
        return false;
    }

    private void handleListCommand() {
        FullName name = new FullName(this.line);
        if (!name.hasCatalogName()) {
            this.gravitinoCommandLine.newListTags(this.context, this.metalake).validate().handle();
        } else {
            this.gravitinoCommandLine.newListEntityTags(this.context, this.metalake, name).validate().handle();
        }
    }

    private void handleDetailsCommand() {
        this.gravitinoCommandLine.newTagDetails(this.context, this.metalake, this.getOneTag(this.tags)).validate().handle();
    }

    private void handleCreateCommand() {
        String comment = this.line.getOptionValue("comment");
        this.gravitinoCommandLine.newCreateTags(this.context, this.metalake, this.tags, comment).validate().handle();
    }

    private void handleDeleteCommand() {
        this.gravitinoCommandLine.newDeleteTag(this.context, this.metalake, this.tags).validate().handle();
    }

    private void handleSetCommand() {
        String property = this.line.getOptionValue("property");
        String value = this.line.getOptionValue("value");
        if (property == null && value == null) {
            this.gravitinoCommandLine.newTagEntity(this.context, this.metalake, new FullName(this.line), this.tags).validate().handle();
        } else {
            this.gravitinoCommandLine.newSetTagProperty(this.context, this.metalake, this.getOneTag(this.tags), property, value).validate().handle();
        }
    }

    private void handleRemoveCommand() {
        boolean isTag = this.line.hasOption("tag");
        FullName name = new FullName(this.line);
        if (!isTag) {
            this.gravitinoCommandLine.newRemoveAllTags(this.context, this.metalake, name).validate().handle();
        } else {
            String propertyRemove = this.line.getOptionValue("property");
            if (propertyRemove != null) {
                this.gravitinoCommandLine.newRemoveTagProperty(this.context, this.metalake, this.getOneTag(this.tags), propertyRemove).validate().handle();
            } else {
                this.gravitinoCommandLine.newUntagEntity(this.context, this.metalake, name, this.tags).validate().handle();
            }
        }
    }

    private void handlePropertiesCommand() {
        this.gravitinoCommandLine.newListTagProperties(this.context, this.metalake, this.getOneTag(this.tags)).validate().handle();
    }

    private void handleUpdateCommand() {
        if (this.line.hasOption("comment")) {
            String updateComment = this.line.getOptionValue("comment");
            this.gravitinoCommandLine.newUpdateTagComment(this.context, this.metalake, this.getOneTag(this.tags), updateComment).validate().handle();
        }
        if (this.line.hasOption("rename")) {
            String newName = this.line.getOptionValue("rename");
            this.gravitinoCommandLine.newUpdateTagName(this.context, this.metalake, this.getOneTag(this.tags), newName).validate().handle();
        }
    }

    private String getOneTag(String[] tags) {
        if (tags == null || tags.length > 1) {
            System.err.println("This command only supports one --tag option.");
            Main.exit(-1);
        }
        return tags[0];
    }
}

