/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.credential;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.credential.Credential;

public class ADLSTokenCredential
implements Credential {
    public static final String ADLS_TOKEN_CREDENTIAL_TYPE = "adls-token";
    public static final String ADLS_DOMAIN = "dfs.core.windows.net";
    public static final String GRAVITINO_AZURE_STORAGE_ACCOUNT_NAME = "azure-storage-account-name";
    public static final String GRAVITINO_ADLS_SAS_TOKEN = "adls-sas-token";
    private String accountName;
    private String sasToken;
    private long expireTimeInMS;

    public ADLSTokenCredential(String accountName, String sasToken, long expireTimeInMS) {
        this.validate(accountName, sasToken, expireTimeInMS);
        this.accountName = accountName;
        this.sasToken = sasToken;
        this.expireTimeInMS = expireTimeInMS;
    }

    public ADLSTokenCredential() {
    }

    @Override
    public String credentialType() {
        return ADLS_TOKEN_CREDENTIAL_TYPE;
    }

    @Override
    public long expireTimeInMs() {
        return this.expireTimeInMS;
    }

    @Override
    public Map<String, String> credentialInfo() {
        return new ImmutableMap.Builder<String, String>().put(GRAVITINO_ADLS_SAS_TOKEN, this.sasToken).put(GRAVITINO_AZURE_STORAGE_ACCOUNT_NAME, this.accountName).build();
    }

    @Override
    public void initialize(Map<String, String> credentialInfo, long expireTimeInMS) {
        String accountName = credentialInfo.get(GRAVITINO_AZURE_STORAGE_ACCOUNT_NAME);
        String sasToken = credentialInfo.get(GRAVITINO_ADLS_SAS_TOKEN);
        this.validate(accountName, sasToken, expireTimeInMS);
        this.accountName = accountName;
        this.sasToken = sasToken;
        this.expireTimeInMS = expireTimeInMS;
    }

    public String accountName() {
        return this.accountName;
    }

    public String sasToken() {
        return this.sasToken;
    }

    private void validate(String accountName, String sasToken, long expireTimeInMS) {
        Preconditions.checkArgument(StringUtils.isNotBlank(accountName), "ADLS account name should not be empty.");
        Preconditions.checkArgument(StringUtils.isNotBlank(sasToken), "ADLS SAS token should not be empty.");
        Preconditions.checkArgument(expireTimeInMS > 0L, "The expire time of ADLSTokenCredential should great than 0");
    }
}

