/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.function;

import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.paimon.annotation.Public;
import org.apache.paimon.function.FunctionDefinition;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.annotation.JsonGetter;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.annotation.JsonSubTypes;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.annotation.JsonTypeInfo;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="action")
@JsonSubTypes(value={@JsonSubTypes.Type(value=SetFunctionOption.class, name="setOption"), @JsonSubTypes.Type(value=RemoveFunctionOption.class, name="removeOption"), @JsonSubTypes.Type(value=UpdateFunctionComment.class, name="updateComment"), @JsonSubTypes.Type(value=AddDefinition.class, name="addDefinition"), @JsonSubTypes.Type(value=UpdateDefinition.class, name="updateDefinition"), @JsonSubTypes.Type(value=DropDefinition.class, name="dropDefinition")})
@Public
public interface FunctionChange
extends Serializable {
    public static FunctionChange setOption(String key, String value) {
        return new SetFunctionOption(key, value);
    }

    public static FunctionChange removeOption(String key) {
        return new RemoveFunctionOption(key);
    }

    public static FunctionChange updateComment(String comment) {
        return new UpdateFunctionComment(comment);
    }

    public static FunctionChange addDefinition(String name, FunctionDefinition definition) {
        return new AddDefinition(name, definition);
    }

    public static FunctionChange updateDefinition(String name, FunctionDefinition definition) {
        return new UpdateDefinition(name, definition);
    }

    public static FunctionChange dropDefinition(String name) {
        return new DropDefinition(name);
    }

    public static class Actions {
        public static final String FIELD_TYPE = "action";
        public static final String ADD_DEFINITION_ACTION = "addDefinition";
        public static final String UPDATE_DEFINITION_ACTION = "updateDefinition";
        public static final String DROP_DEFINITION_ACTION = "dropDefinition";
        public static final String SET_OPTION_ACTION = "setOption";
        public static final String REMOVE_OPTION_ACTION = "removeOption";
        public static final String UPDATE_COMMENT_ACTION = "updateComment";

        private Actions() {
        }
    }

    public static final class DropDefinition
    implements FunctionChange {
        private static final long serialVersionUID = 1L;
        private static final String FIELD_DEFINITION_NAME = "name";
        @JsonProperty(value="name")
        private final String name;

        @JsonCreator
        public DropDefinition(@JsonProperty(value="name") String name) {
            this.name = name;
        }

        @JsonGetter(value="name")
        public String name() {
            return this.name;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            DropDefinition that = (DropDefinition)object;
            return Objects.equals(this.name, that.name);
        }

        public int hashCode() {
            return Objects.hash(this.name);
        }
    }

    public static final class UpdateDefinition
    implements FunctionChange {
        private static final long serialVersionUID = 1L;
        private static final String FIELD_DEFINITION_NAME = "name";
        private static final String FIELD_DEFINITION = "definition";
        @JsonProperty(value="name")
        private final String name;
        @JsonProperty(value="definition")
        private final FunctionDefinition definition;

        @JsonCreator
        public UpdateDefinition(@JsonProperty(value="name") String name, @JsonProperty(value="definition") FunctionDefinition definition) {
            this.name = name;
            this.definition = definition;
        }

        @JsonGetter(value="name")
        public String name() {
            return this.name;
        }

        @JsonGetter(value="definition")
        public FunctionDefinition definition() {
            return this.definition;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            UpdateDefinition that = (UpdateDefinition)object;
            return Objects.equals(this.name, that.name) && Objects.equals(this.definition, that.definition);
        }

        public int hashCode() {
            return Objects.hash(this.definition, this.definition);
        }
    }

    public static final class AddDefinition
    implements FunctionChange {
        private static final long serialVersionUID = 1L;
        private static final String FIELD_DEFINITION_NAME = "name";
        private static final String FIELD_DEFINITION = "definition";
        @JsonProperty(value="name")
        private final String name;
        @JsonProperty(value="definition")
        private final FunctionDefinition definition;

        @JsonCreator
        public AddDefinition(@JsonProperty(value="name") String name, @JsonProperty(value="definition") FunctionDefinition definition) {
            this.name = name;
            this.definition = definition;
        }

        @JsonGetter(value="name")
        public String name() {
            return this.name;
        }

        @JsonGetter(value="definition")
        public FunctionDefinition definition() {
            return this.definition;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            AddDefinition that = (AddDefinition)object;
            return Objects.equals(this.name, that.name) && Objects.equals(this.definition, that.definition);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.definition);
        }
    }

    public static final class UpdateFunctionComment
    implements FunctionChange {
        private static final long serialVersionUID = 1L;
        private static final String FIELD_COMMENT = "comment";
        @JsonProperty(value="comment")
        @Nullable
        private final String comment;

        private UpdateFunctionComment(@JsonProperty(value="comment") @Nullable String comment) {
            this.comment = comment;
        }

        @JsonGetter(value="comment")
        @Nullable
        public String comment() {
            return this.comment;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            UpdateFunctionComment that = (UpdateFunctionComment)object;
            return Objects.equals(this.comment, that.comment);
        }

        public int hashCode() {
            return Objects.hash(this.comment);
        }
    }

    public static final class RemoveFunctionOption
    implements FunctionChange {
        private static final long serialVersionUID = 1L;
        private static final String FIELD_KEY = "key";
        @JsonProperty(value="key")
        private final String key;

        private RemoveFunctionOption(@JsonProperty(value="key") String key) {
            this.key = key;
        }

        @JsonGetter(value="key")
        public String key() {
            return this.key;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RemoveFunctionOption that = (RemoveFunctionOption)o;
            return this.key.equals(that.key);
        }

        public int hashCode() {
            return Objects.hash(this.key);
        }
    }

    public static final class SetFunctionOption
    implements FunctionChange {
        private static final long serialVersionUID = 1L;
        private static final String FIELD_KEY = "key";
        private static final String FIELD_VALUE = "value";
        @JsonProperty(value="key")
        private final String key;
        @JsonProperty(value="value")
        private final String value;

        @JsonCreator
        private SetFunctionOption(@JsonProperty(value="key") String key, @JsonProperty(value="value") String value) {
            this.key = key;
            this.value = value;
        }

        @JsonGetter(value="key")
        public String key() {
            return this.key;
        }

        @JsonGetter(value="value")
        public String value() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SetFunctionOption that = (SetFunctionOption)o;
            return this.key.equals(that.key) && this.value.equals(that.value);
        }

        public int hashCode() {
            return Objects.hash(this.key, this.value);
        }
    }
}

