/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.fs;

import java.util.concurrent.CompletableFuture;

public interface FileRange {
    public long getOffset();

    public int getLength();

    public CompletableFuture<byte[]> getData();

    public static FileRange createFileRange(long offset, int length) {
        return new FileRangeImpl(offset, length);
    }

    public static class FileRangeImpl
    implements FileRange {
        private final long offset;
        private final int length;
        private final CompletableFuture<byte[]> reader;

        public FileRangeImpl(long offset, int length) {
            this.offset = offset;
            this.length = length;
            this.reader = new CompletableFuture();
        }

        public String toString() {
            return "range[" + this.offset + "," + (this.offset + (long)this.length) + ")";
        }

        @Override
        public long getOffset() {
            return this.offset;
        }

        @Override
        public int getLength() {
            return this.length;
        }

        @Override
        public CompletableFuture<byte[]> getData() {
            return this.reader;
        }
    }
}

