/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.manifest;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.manifest.FileKind;
import org.apache.paimon.manifest.IndexManifestEntry;
import org.apache.paimon.manifest.IndexManifestFile;
import org.apache.paimon.table.BucketMode;
import org.apache.paimon.utils.Pair;
import org.apache.paimon.utils.Preconditions;

public class IndexManifestFileHandler {
    private final IndexManifestFile indexManifestFile;
    private final BucketMode bucketMode;

    IndexManifestFileHandler(IndexManifestFile indexManifestFile, BucketMode bucketMode) {
        this.indexManifestFile = indexManifestFile;
        this.bucketMode = bucketMode;
    }

    String write(@Nullable String previousIndexManifest, List<IndexManifestEntry> newIndexFiles) {
        List<Object> entries = previousIndexManifest == null ? new ArrayList() : this.indexManifestFile.read(previousIndexManifest);
        for (IndexManifestEntry indexManifestEntry : entries) {
            Preconditions.checkArgument((indexManifestEntry.kind() == FileKind.ADD ? 1 : 0) != 0);
        }
        Pair<List<IndexManifestEntry>, List<IndexManifestEntry>> previous = this.separateIndexEntries(entries);
        Pair<List<IndexManifestEntry>, List<IndexManifestEntry>> pair = this.separateIndexEntries(newIndexFiles);
        List<IndexManifestEntry> indexEntries = this.getIndexManifestFileCombine("HASH").combine((List)previous.getLeft(), (List)pair.getLeft());
        indexEntries.addAll(this.getIndexManifestFileCombine("DELETION_VECTORS").combine((List)previous.getRight(), (List)pair.getRight()));
        return this.indexManifestFile.writeWithoutRolling(indexEntries);
    }

    private Pair<List<IndexManifestEntry>, List<IndexManifestEntry>> separateIndexEntries(List<IndexManifestEntry> indexFiles) {
        ArrayList<IndexManifestEntry> hashEntries = new ArrayList<IndexManifestEntry>();
        ArrayList<IndexManifestEntry> dvEntries = new ArrayList<IndexManifestEntry>();
        for (IndexManifestEntry entry : indexFiles) {
            String indexType = entry.indexFile().indexType();
            if (indexType.equals("DELETION_VECTORS")) {
                dvEntries.add(entry);
                continue;
            }
            if (indexType.equals("HASH")) {
                hashEntries.add(entry);
                continue;
            }
            throw new IllegalArgumentException("Can't recognize this index type: " + indexType);
        }
        return Pair.of(hashEntries, dvEntries);
    }

    private IndexManifestFileCombiner getIndexManifestFileCombine(String indexType) {
        if ("DELETION_VECTORS".equals(indexType) && BucketMode.BUCKET_UNAWARE == this.bucketMode) {
            return new GlobalCombiner();
        }
        return new BucketedCombiner();
    }

    private static BucketIdentifier identifier(IndexManifestEntry indexManifestEntry) {
        return new BucketIdentifier(indexManifestEntry.partition(), indexManifestEntry.bucket(), indexManifestEntry.indexFile().indexType());
    }

    private static class BucketIdentifier {
        public final BinaryRow partition;
        public final int bucket;
        public final String indexType;
        private Integer hash;

        private BucketIdentifier(BinaryRow partition, int bucket, String indexType) {
            this.partition = partition;
            this.bucket = bucket;
            this.indexType = indexType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BucketIdentifier that = (BucketIdentifier)o;
            return this.bucket == that.bucket && Objects.equals(this.partition, that.partition) && Objects.equals(this.indexType, that.indexType);
        }

        public int hashCode() {
            if (this.hash == null) {
                this.hash = Objects.hash(this.partition, this.bucket, this.indexType);
            }
            return this.hash;
        }

        public String toString() {
            return "BucketIdentifier{partition=" + this.partition + ", bucket=" + this.bucket + ", indexType='" + this.indexType + '\'' + '}';
        }
    }

    static class BucketedCombiner
    implements IndexManifestFileCombiner {
        BucketedCombiner() {
        }

        @Override
        public List<IndexManifestEntry> combine(List<IndexManifestEntry> prevIndexFiles, List<IndexManifestEntry> newIndexFiles) {
            HashMap<BucketIdentifier, IndexManifestEntry> indexEntries = new HashMap<BucketIdentifier, IndexManifestEntry>();
            for (IndexManifestEntry entry : prevIndexFiles) {
                indexEntries.put(IndexManifestFileHandler.identifier(entry), entry);
            }
            List removed = newIndexFiles.stream().filter(f -> f.kind() == FileKind.DELETE).collect(Collectors.toList());
            List added = newIndexFiles.stream().filter(f -> f.kind() == FileKind.ADD).collect(Collectors.toList());
            for (IndexManifestEntry entry : removed) {
                indexEntries.remove(IndexManifestFileHandler.identifier(entry));
            }
            for (IndexManifestEntry entry : added) {
                indexEntries.put(IndexManifestFileHandler.identifier(entry), entry);
            }
            return new ArrayList<IndexManifestEntry>(indexEntries.values());
        }
    }

    static class GlobalCombiner
    implements IndexManifestFileCombiner {
        GlobalCombiner() {
        }

        @Override
        public List<IndexManifestEntry> combine(List<IndexManifestEntry> prevIndexFiles, List<IndexManifestEntry> newIndexFiles) {
            HashMap<String, IndexManifestEntry> indexEntries = new HashMap<String, IndexManifestEntry>();
            for (IndexManifestEntry entry : prevIndexFiles) {
                indexEntries.put(entry.indexFile().fileName(), entry);
            }
            for (IndexManifestEntry entry : newIndexFiles) {
                if (entry.kind() == FileKind.ADD) {
                    indexEntries.put(entry.indexFile().fileName(), entry);
                    continue;
                }
                indexEntries.remove(entry.indexFile().fileName());
            }
            return new ArrayList<IndexManifestEntry>(indexEntries.values());
        }
    }

    static interface IndexManifestFileCombiner {
        public List<IndexManifestEntry> combine(List<IndexManifestEntry> var1, List<IndexManifestEntry> var2);
    }
}

