/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.operation;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.paimon.Snapshot;
import org.apache.paimon.data.Timestamp;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.FileStatus;
import org.apache.paimon.fs.Path;
import org.apache.paimon.index.IndexFileHandler;
import org.apache.paimon.index.IndexFileMeta;
import org.apache.paimon.manifest.IndexManifestEntry;
import org.apache.paimon.manifest.ManifestFileMeta;
import org.apache.paimon.manifest.ManifestList;
import org.apache.paimon.schema.SchemaManager;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.utils.ChangelogManager;
import org.apache.paimon.utils.DateTimeUtils;
import org.apache.paimon.utils.FileStorePathFactory;
import org.apache.paimon.utils.Pair;
import org.apache.paimon.utils.Preconditions;
import org.apache.paimon.utils.SnapshotManager;
import org.apache.paimon.utils.StringUtils;
import org.apache.paimon.utils.SupplierWithIOException;
import org.apache.paimon.utils.TagManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class OrphanFilesClean
implements Serializable {
    protected static final Logger LOG = LoggerFactory.getLogger(OrphanFilesClean.class);
    protected static final int READ_FILE_RETRY_NUM = 3;
    protected static final int READ_FILE_RETRY_INTERVAL = 5;
    protected final FileStoreTable table;
    protected final FileIO fileIO;
    protected final long olderThanMillis;
    protected final boolean dryRun;
    protected final int partitionKeysNum;
    protected final Path location;

    public OrphanFilesClean(FileStoreTable table, long olderThanMillis, boolean dryRun) {
        this.table = table;
        this.fileIO = table.fileIO();
        this.partitionKeysNum = table.partitionKeys().size();
        this.location = table.location();
        this.olderThanMillis = olderThanMillis;
        this.dryRun = dryRun;
    }

    protected List<String> validBranches() {
        List<String> branches = this.table.branchManager().branches();
        branches.add("main");
        ArrayList<String> abnormalBranches = new ArrayList<String>();
        for (String branch : branches) {
            SchemaManager schemaManager = this.table.schemaManager().copyWithBranch(branch);
            if (schemaManager.latest().isPresent()) continue;
            abnormalBranches.add(branch);
        }
        if (!abnormalBranches.isEmpty()) {
            throw new RuntimeException(String.format("Branches %s have no schemas. Orphan files cleaning aborted. Please check these branches manually.", abnormalBranches));
        }
        return branches;
    }

    protected void cleanSnapshotDir(List<String> branches, Consumer<Path> deletedFilesConsumer, Consumer<Long> deletedFilesLenInBytesConsumer) {
        for (String branch : branches) {
            this.cleanBranchSnapshotDir(branch, deletedFilesConsumer, deletedFilesLenInBytesConsumer);
        }
    }

    protected void cleanBranchSnapshotDir(String branch, Consumer<Path> deletedFilesConsumer, Consumer<Long> deletedFilesLenInBytesConsumer) {
        LOG.info("Start to clean snapshot directory of branch {}.", (Object)branch);
        FileStoreTable branchTable = this.table.switchToBranch(branch);
        SnapshotManager snapshotManager = branchTable.snapshotManager();
        ChangelogManager changelogManager = branchTable.changelogManager();
        List<Pair<Path, Long>> nonSnapshotFiles = this.tryGetNonSnapshotFiles(snapshotManager.snapshotDirectory(), this::oldEnough);
        nonSnapshotFiles.forEach(nonSnapshotFile -> this.cleanFile((Pair<Path, Long>)nonSnapshotFile, deletedFilesConsumer, deletedFilesLenInBytesConsumer));
        List<Pair<Path, Long>> nonChangelogFiles = this.tryGetNonChangelogFiles(changelogManager.changelogDirectory(), this::oldEnough);
        nonChangelogFiles.forEach(nonChangelogFile -> this.cleanFile((Pair<Path, Long>)nonChangelogFile, deletedFilesConsumer, deletedFilesLenInBytesConsumer));
        LOG.info("End to clean snapshot directory of branch {}.", (Object)branch);
    }

    private List<Pair<Path, Long>> tryGetNonSnapshotFiles(Path snapshotDirectory, Predicate<FileStatus> fileStatusFilter) {
        return this.listPathWithFilter(snapshotDirectory, fileStatusFilter, OrphanFilesClean.nonSnapshotFileFilter());
    }

    private List<Pair<Path, Long>> tryGetNonChangelogFiles(Path changelogDirectory, Predicate<FileStatus> fileStatusFilter) {
        return this.listPathWithFilter(changelogDirectory, fileStatusFilter, OrphanFilesClean.nonChangelogFileFilter());
    }

    private List<Pair<Path, Long>> listPathWithFilter(Path directory, Predicate<FileStatus> fileStatusFilter, Predicate<Path> fileFilter) {
        List<FileStatus> statuses = this.tryBestListingDirs(directory);
        return statuses.stream().filter(fileStatusFilter).filter(status -> fileFilter.test(status.getPath())).map(status -> Pair.of((Object)status.getPath(), (Object)status.getLen())).collect(Collectors.toList());
    }

    private static Predicate<Path> nonSnapshotFileFilter() {
        return path -> {
            String name = path.getName();
            return !name.startsWith("snapshot-") && !name.equals("EARLIEST") && !name.equals("LATEST");
        };
    }

    private static Predicate<Path> nonChangelogFileFilter() {
        return path -> {
            String name = path.getName();
            return !name.startsWith("changelog-") && !name.equals("EARLIEST") && !name.equals("LATEST");
        };
    }

    private void cleanFile(Pair<Path, Long> deleteFileInfo, Consumer<Path> deletedFilesConsumer, Consumer<Long> deletedFilesLenInBytesConsumer) {
        Path filePath = (Path)deleteFileInfo.getLeft();
        Long fileSize = (Long)deleteFileInfo.getRight();
        deletedFilesConsumer.accept(filePath);
        deletedFilesLenInBytesConsumer.accept(fileSize);
        this.cleanFile(filePath);
    }

    protected void cleanFile(Path path) {
        if (!this.dryRun) {
            try {
                if (this.fileIO.isDir(path)) {
                    this.fileIO.deleteDirectoryQuietly(path);
                } else {
                    this.fileIO.deleteQuietly(path);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected Set<Snapshot> safelyGetAllSnapshots(String branch) throws IOException {
        FileStoreTable branchTable = this.table.switchToBranch(branch);
        SnapshotManager snapshotManager = branchTable.snapshotManager();
        ChangelogManager changelogManager = branchTable.changelogManager();
        TagManager tagManager = branchTable.tagManager();
        HashSet<Snapshot> readSnapshots = new HashSet<Snapshot>(snapshotManager.safelyGetAllSnapshots());
        readSnapshots.addAll(tagManager.taggedSnapshots());
        readSnapshots.addAll(changelogManager.safelyGetAllChangelogs());
        return readSnapshots;
    }

    protected void collectWithoutDataFile(String branch, Snapshot snapshot, Consumer<String> usedFileConsumer, Consumer<String> manifestConsumer) throws IOException {
        Consumer<Pair<String, Boolean>> usedFileWithFlagConsumer = fileAndFlag -> {
            if (((Boolean)fileAndFlag.getRight()).booleanValue()) {
                manifestConsumer.accept((String)fileAndFlag.getLeft());
            }
            usedFileConsumer.accept((String)fileAndFlag.getLeft());
        };
        this.collectWithoutDataFileWithManifestFlag(branch, snapshot, usedFileWithFlagConsumer);
    }

    protected void collectWithoutDataFileWithManifestFlag(String branch, Snapshot snapshot, Consumer<Pair<String, Boolean>> usedFileWithFlagConsumer) throws IOException {
        FileStoreTable branchTable = this.table.switchToBranch(branch);
        ManifestList manifestList = branchTable.store().manifestListFactory().create();
        IndexFileHandler indexFileHandler = branchTable.store().newIndexFileHandler();
        ArrayList manifestFileMetas = new ArrayList();
        if (snapshot.changelogManifestList() != null) {
            usedFileWithFlagConsumer.accept((Pair<String, Boolean>)Pair.of((Object)snapshot.changelogManifestList(), (Object)false));
            manifestFileMetas.addAll(OrphanFilesClean.retryReadingFiles(() -> manifestList.readWithIOException(snapshot.changelogManifestList()), Collections.emptyList()));
        }
        if (snapshot.deltaManifestList() != null) {
            usedFileWithFlagConsumer.accept((Pair<String, Boolean>)Pair.of((Object)snapshot.deltaManifestList(), (Object)false));
            manifestFileMetas.addAll(OrphanFilesClean.retryReadingFiles(() -> manifestList.readWithIOException(snapshot.deltaManifestList()), Collections.emptyList()));
        }
        usedFileWithFlagConsumer.accept((Pair<String, Boolean>)Pair.of((Object)snapshot.baseManifestList(), (Object)false));
        manifestFileMetas.addAll(OrphanFilesClean.retryReadingFiles(() -> manifestList.readWithIOException(snapshot.baseManifestList()), Collections.emptyList()));
        for (ManifestFileMeta manifest : manifestFileMetas) {
            usedFileWithFlagConsumer.accept((Pair<String, Boolean>)Pair.of((Object)manifest.fileName(), (Object)true));
        }
        String indexManifest = snapshot.indexManifest();
        if (indexManifest != null && indexFileHandler.existsManifest(indexManifest)) {
            usedFileWithFlagConsumer.accept((Pair<String, Boolean>)Pair.of((Object)indexManifest, (Object)false));
            OrphanFilesClean.retryReadingFiles(() -> indexFileHandler.readManifestWithIOException(indexManifest), Collections.emptyList()).stream().map(IndexManifestEntry::indexFile).map(IndexFileMeta::fileName).forEach(name -> usedFileWithFlagConsumer.accept(Pair.of((Object)name, (Object)false)));
        }
        if (snapshot.statistics() != null) {
            usedFileWithFlagConsumer.accept((Pair<String, Boolean>)Pair.of((Object)snapshot.statistics(), (Object)false));
        }
    }

    protected List<Path> listPaimonFileDirs() {
        FileStorePathFactory pathFactory = this.table.store().pathFactory();
        return this.listPaimonFileDirs(this.table.fullName(), pathFactory.manifestPath().toString(), pathFactory.indexPath().toString(), pathFactory.statisticsPath().toString(), pathFactory.dataFilePath().toString(), this.partitionKeysNum, this.table.store().options().dataFileExternalPaths());
    }

    protected List<Path> listPaimonFileDirs(String tableName, String manifestPath, String indexPath, String statisticsPath, String dataFilePath, int partitionKeysNum, String dataFileExternalPaths) {
        LOG.info("Start: listing paimon file directories for table [{}]", (Object)tableName);
        long start = System.currentTimeMillis();
        ArrayList<Path> paimonFileDirs = new ArrayList<Path>();
        paimonFileDirs.add(new Path(manifestPath));
        paimonFileDirs.add(new Path(indexPath));
        paimonFileDirs.add(new Path(statisticsPath));
        paimonFileDirs.addAll(this.listFileDirs(new Path(dataFilePath), partitionKeysNum));
        if (dataFileExternalPaths != null) {
            String[] externalPathArr;
            for (String externalPath : externalPathArr = dataFileExternalPaths.split(",")) {
                paimonFileDirs.addAll(this.listFileDirs(new Path(externalPath), partitionKeysNum));
            }
        }
        LOG.info("End list paimon file directories for table [{}] spend [{}] ms", (Object)tableName, (Object)(System.currentTimeMillis() - start));
        return paimonFileDirs;
    }

    private List<Path> listFileDirs(Path dir, int level) {
        List<FileStatus> dirs = this.tryBestListingDirs(dir);
        if (level == 0) {
            return this.filterDirs(dirs, p -> p.getName().startsWith("bucket-"));
        }
        List<Path> partitionPaths = this.filterDirs(dirs, p -> p.getName().contains("="));
        ArrayList<Path> result = new ArrayList<Path>();
        for (Path partitionPath : partitionPaths) {
            result.addAll(this.listFileDirs(partitionPath, level - 1));
        }
        return result;
    }

    private List<Path> filterDirs(List<FileStatus> statuses, Predicate<Path> filter) {
        ArrayList<Path> filtered = new ArrayList<Path>();
        for (FileStatus status : statuses) {
            Path path = status.getPath();
            if (!filter.test(path)) continue;
            filtered.add(path);
        }
        return filtered;
    }

    protected List<FileStatus> tryBestListingDirs(Path dir) {
        try {
            if (!this.fileIO.exists(dir)) {
                return Collections.emptyList();
            }
            return OrphanFilesClean.retryReadingFiles(() -> {
                FileStatus[] s = this.fileIO.listStatus(dir);
                return s == null ? Collections.emptyList() : Arrays.asList(s);
            }, Collections.emptyList());
        }
        catch (IOException e) {
            LOG.debug("Failed to list directory {}, skip it.", (Object)dir, (Object)e);
            return Collections.emptyList();
        }
    }

    protected static <T> T retryReadingFiles(SupplierWithIOException<T> reader, T defaultValue) throws IOException {
        int retryNumber = 0;
        IOException caught = null;
        while (retryNumber++ < 3) {
            try {
                return (T)reader.get();
            }
            catch (FileNotFoundException e) {
                return defaultValue;
            }
            catch (IOException e) {
                caught = e;
                try {
                    TimeUnit.MILLISECONDS.sleep(5L);
                }
                catch (InterruptedException e2) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException(e2);
                }
            }
        }
        throw caught;
    }

    protected boolean oldEnough(FileStatus status) {
        return status.getModificationTime() < this.olderThanMillis;
    }

    public static long olderThanMillis(@Nullable String olderThan) {
        if (StringUtils.isNullOrWhitespaceOnly((String)olderThan)) {
            return System.currentTimeMillis() - TimeUnit.DAYS.toMillis(1L);
        }
        Timestamp parsedTimestampData = DateTimeUtils.parseTimestampData((String)olderThan, (int)3, (TimeZone)TimeZone.getDefault());
        Preconditions.checkArgument((parsedTimestampData.compareTo(Timestamp.fromEpochMillis((long)System.currentTimeMillis())) < 0 ? 1 : 0) != 0, (Object)"The arg olderThan must be less than now, because dataFiles that are currently being written and not referenced by snapshots will be mistakenly cleaned up.");
        return parsedTimestampData.getMillisecond();
    }

    protected void tryCleanDataDirectory(Set<Path> dataDirs, int maxLevel) {
        for (int level = 0; level < maxLevel; ++level) {
            dataDirs = dataDirs.stream().filter(this::tryDeleteEmptyDirectory).map(Path::getParent).collect(Collectors.toSet());
        }
    }

    public boolean tryDeleteEmptyDirectory(Path path) {
        if (this.dryRun) {
            return false;
        }
        try {
            return this.fileIO.delete(path, false);
        }
        catch (IOException e) {
            return false;
        }
    }

    public static interface FileCleaner
    extends Serializable {
        public void clean(String var1, Path var2);
    }
}

