/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.slice;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import sun.misc.Unsafe;

final class JvmUtils {
    static final Unsafe unsafe;
    static final MethodHandle newByteBuffer;
    private static final Field ADDRESS_ACCESSOR;

    private static void assertArrayIndexScale(String name, int actualIndexScale, int expectedIndexScale) {
        if (actualIndexScale != expectedIndexScale) {
            throw new IllegalStateException(name + " array index scale must be " + expectedIndexScale + ", but is " + actualIndexScale);
        }
    }

    public static long getAddress(Buffer buffer) {
        try {
            return (Long)ADDRESS_ACCESSOR.get(buffer);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private JvmUtils() {
    }

    static {
        try {
            Field field = Unsafe.class.getDeclaredField("theUnsafe");
            field.setAccessible(true);
            unsafe = (Unsafe)field.get(null);
            if (unsafe == null) {
                throw new RuntimeException("Unsafe access not available");
            }
            JvmUtils.assertArrayIndexScale("Boolean", Unsafe.ARRAY_BOOLEAN_INDEX_SCALE, 1);
            JvmUtils.assertArrayIndexScale("Byte", Unsafe.ARRAY_BYTE_INDEX_SCALE, 1);
            JvmUtils.assertArrayIndexScale("Short", Unsafe.ARRAY_SHORT_INDEX_SCALE, 2);
            JvmUtils.assertArrayIndexScale("Int", Unsafe.ARRAY_INT_INDEX_SCALE, 4);
            JvmUtils.assertArrayIndexScale("Long", Unsafe.ARRAY_LONG_INDEX_SCALE, 8);
            JvmUtils.assertArrayIndexScale("Float", Unsafe.ARRAY_FLOAT_INDEX_SCALE, 4);
            JvmUtils.assertArrayIndexScale("Double", Unsafe.ARRAY_DOUBLE_INDEX_SCALE, 8);
            Class<?> directByteBufferClass = ClassLoader.getSystemClassLoader().loadClass("java.nio.DirectByteBuffer");
            Constructor<?> constructor = directByteBufferClass.getDeclaredConstructor(Long.TYPE, Integer.TYPE, Object.class);
            constructor.setAccessible(true);
            newByteBuffer = MethodHandles.lookup().unreflectConstructor(constructor).asType(MethodType.methodType(ByteBuffer.class, Long.TYPE, Integer.TYPE, Object.class));
            ADDRESS_ACCESSOR = Buffer.class.getDeclaredField("address");
            ADDRESS_ACCESSOR.setAccessible(true);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

