/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.server.authorization;

import java.lang.reflect.Array;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.function.Function;
import org.apache.gravitino.Config;
import org.apache.gravitino.Configs;
import org.apache.gravitino.Entity;
import org.apache.gravitino.GravitinoEnv;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.authorization.AuthorizationRequestContext;
import org.apache.gravitino.authorization.GravitinoAuthorizer;
import org.apache.gravitino.authorization.Privilege;
import org.apache.gravitino.server.authorization.GravitinoAuthorizerProvider;
import org.apache.gravitino.server.authorization.expression.AuthorizationExpressionEvaluator;
import org.apache.gravitino.utils.NameIdentifierUtil;
import org.apache.gravitino.utils.PrincipalUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataFilterHelper {
    private static final Logger LOG = LoggerFactory.getLogger(MetadataFilterHelper.class);
    private static volatile Executor executor = null;

    private MetadataFilterHelper() {
    }

    public static NameIdentifier[] filterByPrivilege(String metalake, Entity.EntityType entityType, String privilege, NameIdentifier[] metadataList) {
        if (!MetadataFilterHelper.enableAuthorization()) {
            return metadataList;
        }
        MetadataFilterHelper.checkExecutor();
        GravitinoAuthorizer gravitinoAuthorizer = GravitinoAuthorizerProvider.getInstance().getGravitinoAuthorizer();
        Principal currentPrincipal = PrincipalUtils.getCurrentPrincipal();
        AuthorizationRequestContext authorizationRequestContext = new AuthorizationRequestContext();
        return (NameIdentifier[])Arrays.stream(metadataList).filter(metaDataName -> gravitinoAuthorizer.authorize(currentPrincipal, metalake, NameIdentifierUtil.toMetadataObject((NameIdentifier)metaDataName, (Entity.EntityType)entityType), Privilege.Name.valueOf((String)privilege), authorizationRequestContext)).toArray(NameIdentifier[]::new);
    }

    public static NameIdentifier[] filterByExpression(String metalake, String expression, Entity.EntityType entityType, NameIdentifier[] nameIdentifiers) {
        if (!MetadataFilterHelper.enableAuthorization()) {
            return nameIdentifiers;
        }
        MetadataFilterHelper.checkExecutor();
        AuthorizationRequestContext authorizationRequestContext = new AuthorizationRequestContext();
        ArrayList<CompletableFuture<NameIdentifier>> futures = new ArrayList<CompletableFuture<NameIdentifier>>();
        for (NameIdentifier nameIdentifier : nameIdentifiers) {
            Principal currentPrincipal = PrincipalUtils.getCurrentPrincipal();
            futures.add(CompletableFuture.supplyAsync(() -> {
                try {
                    return (NameIdentifier)PrincipalUtils.doAs((Principal)currentPrincipal, () -> {
                        AuthorizationExpressionEvaluator authorizationExpressionEvaluator = new AuthorizationExpressionEvaluator(expression);
                        Map<Entity.EntityType, NameIdentifier> nameIdentifierMap = MetadataFilterHelper.spiltMetadataNames(metalake, entityType, nameIdentifier);
                        return authorizationExpressionEvaluator.evaluate(nameIdentifierMap, authorizationRequestContext) ? nameIdentifier : null;
                    });
                }
                catch (Exception e) {
                    LOG.error("GravitinoAuthorize error:{}", (Object)e.getMessage(), (Object)e);
                    return null;
                }
            }, executor));
        }
        return (NameIdentifier[])futures.stream().map(CompletableFuture::join).filter(Objects::nonNull).toArray(NameIdentifier[]::new);
    }

    public static <E> E[] filterByExpression(String metalake, String expression, Entity.EntityType entityType, E[] entities, Function<E, NameIdentifier> toNameIdentifier) {
        GravitinoAuthorizer authorizer = GravitinoAuthorizerProvider.getInstance().getGravitinoAuthorizer();
        Principal currentPrincipal = PrincipalUtils.getCurrentPrincipal();
        return MetadataFilterHelper.filterByExpression(metalake, expression, entityType, entities, toNameIdentifier, currentPrincipal, authorizer);
    }

    public static <E> E[] filterByExpression(String metalake, String expression, Entity.EntityType entityType, E[] entities, Function<E, NameIdentifier> toNameIdentifier, Principal currentPrincipal, GravitinoAuthorizer authorizer) {
        if (!MetadataFilterHelper.enableAuthorization()) {
            return entities;
        }
        MetadataFilterHelper.checkExecutor();
        AuthorizationRequestContext authorizationRequestContext = new AuthorizationRequestContext();
        ArrayList<CompletableFuture<Object>> futures = new ArrayList<CompletableFuture<Object>>();
        for (Object entity : entities) {
            futures.add(CompletableFuture.supplyAsync(() -> {
                try {
                    return PrincipalUtils.doAs((Principal)currentPrincipal, () -> {
                        AuthorizationExpressionEvaluator authorizationExpressionEvaluator = new AuthorizationExpressionEvaluator(expression, authorizer);
                        NameIdentifier nameIdentifier = (NameIdentifier)toNameIdentifier.apply(entity);
                        Map<Entity.EntityType, NameIdentifier> nameIdentifierMap = MetadataFilterHelper.spiltMetadataNames(metalake, entityType, nameIdentifier);
                        return authorizationExpressionEvaluator.evaluate(nameIdentifierMap, authorizationRequestContext) ? entity : null;
                    });
                }
                catch (Exception e) {
                    LOG.error("GravitinoAuthorize error:{}", (Object)e.getMessage(), (Object)e);
                    return null;
                }
            }, executor));
        }
        return futures.stream().map(CompletableFuture::join).filter(Objects::nonNull).toArray(size -> (Object[])Array.newInstance(entities.getClass().getComponentType(), size));
    }

    private static Map<Entity.EntityType, NameIdentifier> spiltMetadataNames(String metalake, Entity.EntityType entityType, NameIdentifier nameIdentifier) {
        HashMap<Entity.EntityType, NameIdentifier> nameIdentifierMap = new HashMap<Entity.EntityType, NameIdentifier>();
        nameIdentifierMap.put(Entity.EntityType.METALAKE, NameIdentifierUtil.ofMetalake((String)metalake));
        switch (entityType) {
            case CATALOG: {
                nameIdentifierMap.put(Entity.EntityType.CATALOG, nameIdentifier);
                break;
            }
            case SCHEMA: {
                nameIdentifierMap.put(Entity.EntityType.SCHEMA, nameIdentifier);
                nameIdentifierMap.put(Entity.EntityType.CATALOG, NameIdentifierUtil.getCatalogIdentifier((NameIdentifier)nameIdentifier));
                break;
            }
            case TABLE: {
                nameIdentifierMap.put(Entity.EntityType.TABLE, nameIdentifier);
                nameIdentifierMap.put(Entity.EntityType.SCHEMA, NameIdentifierUtil.getSchemaIdentifier((NameIdentifier)nameIdentifier));
                nameIdentifierMap.put(Entity.EntityType.CATALOG, NameIdentifierUtil.getCatalogIdentifier((NameIdentifier)nameIdentifier));
                break;
            }
            case MODEL: {
                nameIdentifierMap.put(Entity.EntityType.MODEL, nameIdentifier);
                nameIdentifierMap.put(Entity.EntityType.SCHEMA, NameIdentifierUtil.getSchemaIdentifier((NameIdentifier)nameIdentifier));
                nameIdentifierMap.put(Entity.EntityType.CATALOG, NameIdentifierUtil.getCatalogIdentifier((NameIdentifier)nameIdentifier));
                break;
            }
            case MODEL_VERSION: {
                nameIdentifierMap.put(Entity.EntityType.MODEL_VERSION, nameIdentifier);
                nameIdentifierMap.put(Entity.EntityType.MODEL, NameIdentifierUtil.getModelIdentifier((NameIdentifier)nameIdentifier));
                nameIdentifierMap.put(Entity.EntityType.SCHEMA, NameIdentifierUtil.getSchemaIdentifier((NameIdentifier)nameIdentifier));
                nameIdentifierMap.put(Entity.EntityType.CATALOG, NameIdentifierUtil.getCatalogIdentifier((NameIdentifier)nameIdentifier));
                break;
            }
            case TOPIC: {
                nameIdentifierMap.put(Entity.EntityType.TOPIC, nameIdentifier);
                nameIdentifierMap.put(Entity.EntityType.SCHEMA, NameIdentifierUtil.getSchemaIdentifier((NameIdentifier)nameIdentifier));
                nameIdentifierMap.put(Entity.EntityType.CATALOG, NameIdentifierUtil.getCatalogIdentifier((NameIdentifier)nameIdentifier));
                break;
            }
            case FILESET: {
                nameIdentifierMap.put(Entity.EntityType.FILESET, nameIdentifier);
                nameIdentifierMap.put(Entity.EntityType.SCHEMA, NameIdentifierUtil.getSchemaIdentifier((NameIdentifier)nameIdentifier));
                nameIdentifierMap.put(Entity.EntityType.CATALOG, NameIdentifierUtil.getCatalogIdentifier((NameIdentifier)nameIdentifier));
                break;
            }
            case METALAKE: {
                nameIdentifierMap.put(entityType, nameIdentifier);
                break;
            }
            case ROLE: {
                nameIdentifierMap.put(entityType, nameIdentifier);
                break;
            }
            case USER: {
                nameIdentifierMap.put(entityType, nameIdentifier);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported entity type: " + String.valueOf(entityType));
            }
        }
        return nameIdentifierMap;
    }

    private static boolean enableAuthorization() {
        Config config = GravitinoEnv.getInstance().config();
        return config != null && (Boolean)config.get(Configs.ENABLE_AUTHORIZATION) != false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void checkExecutor() {
        if (executor != null) return;
        Class<MetadataFilterHelper> clazz = MetadataFilterHelper.class;
        synchronized (MetadataFilterHelper.class) {
            if (executor != null) return;
            executor = Executors.newFixedThreadPool((Integer)GravitinoEnv.getInstance().config().get(Configs.GRAVITINO_AUTHORIZATION_THREAD_POOL_SIZE), runnable -> {
                Thread thread = new Thread(runnable);
                thread.setDaemon(true);
                thread.setName("MetadataFilterHelper-ThreadPool-" + thread.getId());
                return thread;
            });
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }
}

