/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.io;

import java.io.IOException;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hugegraph.computer.core.common.ComputerContext;
import org.apache.hugegraph.computer.core.config.ComputerOptions;
import org.apache.hugegraph.computer.core.config.Config;
import org.apache.hugegraph.computer.core.config.EdgeFrequency;
import org.apache.hugegraph.computer.core.graph.GraphFactory;
import org.apache.hugegraph.computer.core.graph.edge.Edge;
import org.apache.hugegraph.computer.core.graph.id.BytesId;
import org.apache.hugegraph.computer.core.graph.id.Id;
import org.apache.hugegraph.computer.core.graph.properties.Properties;
import org.apache.hugegraph.computer.core.graph.value.Value;
import org.apache.hugegraph.computer.core.graph.vertex.Vertex;
import org.apache.hugegraph.computer.core.io.GraphComputeInput;
import org.apache.hugegraph.computer.core.io.RandomAccessInput;
import org.apache.hugegraph.computer.core.store.entry.EntryInput;
import org.apache.hugegraph.computer.core.store.entry.KvEntryReader;
import org.apache.hugegraph.config.TypedOption;

public class StreamGraphInput
implements GraphComputeInput {
    private final GraphFactory graphFactory;
    private final Config config;
    private final EdgeFrequency frequency;
    private final EntryInput in;

    public StreamGraphInput(ComputerContext context, EntryInput in) {
        this.graphFactory = context.graphFactory();
        this.config = context.config();
        this.frequency = (EdgeFrequency)context.config().get((TypedOption)ComputerOptions.INPUT_EDGE_FREQ);
        this.in = in;
    }

    public Vertex readVertex() throws IOException {
        Vertex vertex = this.graphFactory.createVertex();
        this.in.readEntry(in -> vertex.id(StreamGraphInput.readId(in)), in -> {
            vertex.label(StreamGraphInput.readLabel(in));
            vertex.properties(this.readProperties(in));
        });
        return vertex;
    }

    public Vertex readEdges() throws IOException {
        Vertex vertex = this.graphFactory.createVertex();
        KvEntryReader reader = this.in.readEntry(in -> vertex.id(StreamGraphInput.readId(in)));
        if (this.frequency == EdgeFrequency.SINGLE) {
            while (reader.hasRemaining()) {
                Edge edge = this.graphFactory.createEdge();
                reader.readSubKv(in -> edge.targetId(StreamGraphInput.readId(in)), in -> edge.properties(this.readProperties(in)));
                vertex.addEdge(edge);
            }
        } else if (this.frequency == EdgeFrequency.SINGLE_PER_LABEL) {
            while (reader.hasRemaining()) {
                Edge edge = this.graphFactory.createEdge();
                reader.readSubKv(in -> {
                    edge.label(StreamGraphInput.readLabel(in));
                    edge.targetId(StreamGraphInput.readId(in));
                }, in -> edge.properties(this.readProperties(in)));
                vertex.addEdge(edge);
            }
        } else {
            assert (this.frequency == EdgeFrequency.MULTIPLE);
            while (reader.hasRemaining()) {
                Edge edge = this.graphFactory.createEdge();
                reader.readSubKv(in -> {
                    edge.label(StreamGraphInput.readLabel(in));
                    edge.name(StreamGraphInput.readLabel(in));
                    edge.targetId(StreamGraphInput.readId(in));
                }, in -> edge.properties(this.readProperties(in)));
                vertex.addEdge(edge);
            }
        }
        return vertex;
    }

    public Pair<Id, Value> readMessage() throws IOException {
        MutablePair pair = MutablePair.of(null, null);
        this.in.readEntry(in -> pair.setLeft((Object)StreamGraphInput.readId(in)), in -> pair.setRight((Object)this.readMessage(in)));
        return pair;
    }

    private Value readMessage(RandomAccessInput in) throws IOException {
        Value value = (Value)this.config.createObject(ComputerOptions.ALGORITHM_MESSAGE_CLASS);
        value.read(in);
        return value;
    }

    public Value readValue(RandomAccessInput in) throws IOException {
        byte code = in.readByte();
        Value value = this.graphFactory.createValue(code);
        value.read(in);
        return value;
    }

    private Properties readProperties(RandomAccessInput in) throws IOException {
        Properties properties = this.graphFactory.createProperties();
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            String key = in.readUTF();
            Value value = this.readValue(in);
            properties.put(key, value);
        }
        return properties;
    }

    public static Id readId(RandomAccessInput in) throws IOException {
        BytesId id = new BytesId();
        id.read(in);
        return id;
    }

    public static String readLabel(RandomAccessInput in) throws IOException {
        return in.readUTF();
    }
}

