/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.seg.common.wrapper;

import com.hankcs.hanlp.seg.Segment;
import com.hankcs.hanlp.seg.common.Term;
import com.hankcs.hanlp.utility.TextUtility;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.List;

public class SegmentWrapper {
    BufferedReader br;
    Segment segment;
    Term[] termArray;
    int index;

    public SegmentWrapper(BufferedReader br, Segment segment) {
        this.br = br;
        this.segment = segment;
    }

    public void reset(BufferedReader br) {
        this.br = br;
        this.termArray = null;
        this.index = 0;
    }

    public Term next() throws IOException {
        if (this.termArray != null && this.index < this.termArray.length) {
            return this.termArray[this.index++];
        }
        String line = this.br.readLine();
        while (TextUtility.isBlank(line)) {
            if (line == null) {
                return null;
            }
            line = this.br.readLine();
        }
        List<Term> termList = this.segment.seg(line);
        if (termList.size() == 0) {
            return null;
        }
        this.termArray = termList.toArray(new Term[0]);
        this.index = 0;
        return this.termArray[this.index++];
    }
}

