/*
 * Decompiled with CFR 0.152.
 */
package com.chenlb.mmseg4j;

import com.chenlb.mmseg4j.Chunk;
import com.chenlb.mmseg4j.ComplexSeg;
import com.chenlb.mmseg4j.Dictionary;
import com.chenlb.mmseg4j.Sentence;
import com.chenlb.mmseg4j.Word;
import java.util.ArrayList;

public class MaxWordSeg
extends ComplexSeg {
    public MaxWordSeg(Dictionary dic) {
        super(dic);
    }

    @Override
    public Chunk seg(Sentence sen) {
        Chunk chunk = super.seg(sen);
        if (chunk != null) {
            ArrayList<Word> cks = new ArrayList<Word>();
            for (int i = 0; i < chunk.getCount(); ++i) {
                int offset;
                Word word = chunk.words[i];
                if (word.getLength() < 3) {
                    cks.add(word);
                    continue;
                }
                char[] chs = word.getSen();
                int n = 0;
                int wordEnd = word.getWordOffset() + word.getLength();
                int senStartOffset = word.getStartOffset() - offset;
                int end = -1;
                for (offset = word.getWordOffset(); offset < wordEnd - 1; ++offset) {
                    int idx = this.search(chs, offset, 1);
                    if (idx > -1) {
                        cks.add(new Word(chs, senStartOffset, offset, 2));
                        end = offset + 2;
                        ++n;
                        continue;
                    }
                    if (offset < end) continue;
                    cks.add(new Word(chs, senStartOffset, offset, 1));
                    end = offset + 1;
                }
                if (end <= -1 || end >= wordEnd) continue;
                cks.add(new Word(chs, senStartOffset, offset, 1));
            }
            chunk.words = cks.toArray(new Word[cks.size()]);
            chunk.count = cks.size();
        }
        return chunk;
    }
}

