/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.api.traversers;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hugegraph.HugeGraph;
import org.apache.hugegraph.api.API;
import org.apache.hugegraph.traversal.algorithm.steps.EdgeStep;
import org.apache.hugegraph.traversal.algorithm.steps.Steps;
import org.apache.hugegraph.type.define.Directions;

public class TraverserAPI
extends API {
    protected static EdgeStep step(HugeGraph graph, Step step) {
        return new EdgeStep(graph, step.direction, step.labels, step.properties, step.maxDegree, step.skipDegree);
    }

    protected static Steps steps(HugeGraph graph, VESteps steps) {
        HashMap<String, Map<String, Object>> vSteps = new HashMap<String, Map<String, Object>>();
        if (steps.vSteps != null) {
            for (VEStepEntity vStep : steps.vSteps) {
                vSteps.put(vStep.label, vStep.properties);
            }
        }
        HashMap<String, Map<String, Object>> eSteps = new HashMap<String, Map<String, Object>>();
        if (steps.eSteps != null) {
            for (VEStepEntity eStep : steps.eSteps) {
                eSteps.put(eStep.label, eStep.properties);
            }
        }
        return new Steps(graph, steps.direction, vSteps, eSteps, steps.maxDegree, steps.skipDegree);
    }

    protected static class VESteps {
        @JsonProperty(value="direction")
        public Directions direction;
        @JsonAlias(value={"degree"})
        @JsonProperty(value="max_degree")
        public long maxDegree = Long.parseLong("10000");
        @JsonProperty(value="skip_degree")
        public long skipDegree = 0L;
        @JsonProperty(value="vertex_steps")
        public List<VEStepEntity> vSteps;
        @JsonProperty(value="edge_steps")
        public List<VEStepEntity> eSteps;

        protected VESteps() {
        }

        public String toString() {
            return String.format("Steps{direction=%s,maxDegree=%s,skipDegree=%s,vSteps=%s,eSteps=%s}", this.direction, this.maxDegree, this.skipDegree, this.vSteps, this.eSteps);
        }
    }

    protected static class VEStepEntity {
        @JsonProperty(value="label")
        public String label;
        @JsonProperty(value="properties")
        public Map<String, Object> properties;

        protected VEStepEntity() {
        }

        public String toString() {
            return String.format("VEStepEntity{label=%s,properties=%s}", this.label, this.properties);
        }
    }

    protected static class Step {
        @JsonProperty(value="direction")
        public Directions direction;
        @JsonProperty(value="labels")
        public List<String> labels;
        @JsonProperty(value="properties")
        public Map<String, Object> properties;
        @JsonAlias(value={"degree"})
        @JsonProperty(value="max_degree")
        public long maxDegree = Long.parseLong("10000");
        @JsonProperty(value="skip_degree")
        public long skipDegree = 0L;

        protected Step() {
        }

        public String toString() {
            return String.format("Step{direction=%s,labels=%s,properties=%s,maxDegree=%s,skipDegree=%s}", this.direction, this.labels, this.properties, this.maxDegree, this.skipDegree);
        }
    }
}

