/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.filter;

import com.alipay.common.tracer.core.holder.SofaTraceContextHolder;
import com.alipay.common.tracer.core.span.SofaTracerSpan;
import com.alipay.common.tracer.core.utils.TracerUtils;
import com.alipay.sofa.rpc.common.MetadataHolder;
import com.alipay.sofa.rpc.core.exception.SofaRpcException;
import com.alipay.sofa.rpc.core.request.SofaRequest;
import com.alipay.sofa.rpc.core.response.SofaResponse;
import com.alipay.sofa.rpc.ext.Extension;
import com.alipay.sofa.rpc.filter.AutoActive;
import com.alipay.sofa.rpc.filter.Filter;
import com.alipay.sofa.rpc.filter.FilterInvoker;
import com.alipay.sofa.rpc.server.triple.TripleHeadKeys;
import com.alipay.sofa.rpc.tracer.sofatracer.TracingContextKey;
import io.grpc.Metadata;
import java.util.Map;

@Extension(value="pressure")
@AutoActive(consumerSide=true, providerSide=true)
public class PressureMarkTransformFilter
extends Filter {
    public static final String PRESSURE = "pressure";
    public static final String MARK = "mark";
    public static final String T = "T";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SofaResponse invoke(FilterInvoker invoker, SofaRequest request) throws SofaRpcException {
        String s;
        Metadata metadata;
        SofaTracerSpan currentSpan = SofaTraceContextHolder.getSofaTraceContext().getCurrentSpan();
        boolean loadTest = TracerUtils.isLoadTest((SofaTracerSpan)currentSpan);
        if (loadTest) {
            Map<String, String> metaHolder = MetadataHolder.getMetaHolder();
            metaHolder.put(TripleHeadKeys.HEAD_KEY_TRAFFIC_TYPE.name(), PRESSURE);
        }
        if ((metadata = (Metadata)TracingContextKey.getKeyMetadata().get()) != null && PRESSURE.equals(s = (String)metadata.get(TripleHeadKeys.HEAD_KEY_TRAFFIC_TYPE))) {
            currentSpan.getSofaTracerSpanContext().setBizBaggageItem(MARK, T);
        }
        try {
            SofaResponse sofaResponse = invoker.invoke(request);
            return sofaResponse;
        }
        finally {
            MetadataHolder.clear();
        }
    }
}

