/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.repl.load.message;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.hadoop.hive.metastore.api.SQLCheckConstraint;
import org.apache.hadoop.hive.metastore.api.SQLDefaultConstraint;
import org.apache.hadoop.hive.metastore.api.SQLForeignKey;
import org.apache.hadoop.hive.metastore.api.SQLNotNullConstraint;
import org.apache.hadoop.hive.metastore.api.SQLPrimaryKey;
import org.apache.hadoop.hive.metastore.api.SQLUniqueConstraint;
import org.apache.hadoop.hive.metastore.messaging.AddNotNullConstraintMessage;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.repl.load.message.AbstractMessageHandler;
import org.apache.hadoop.hive.ql.parse.repl.load.message.MessageHandler;
import org.apache.hadoop.hive.ql.plan.AlterTableDesc;
import org.apache.hadoop.hive.ql.plan.DDLWork;

public class AddNotNullConstraintHandler
extends AbstractMessageHandler {
    @Override
    public List<Task<? extends Serializable>> handle(MessageHandler.Context context) throws SemanticException {
        AddNotNullConstraintMessage msg = this.deserializer.getAddNotNullConstraintMessage(context.dmd.getPayload());
        List<SQLNotNullConstraint> nns = null;
        try {
            nns = msg.getNotNullConstraints();
        }
        catch (Exception e) {
            if (!(e instanceof SemanticException)) {
                throw new SemanticException("Error reading message members", e);
            }
            throw (SemanticException)e;
        }
        ArrayList<Task<? extends Serializable>> tasks = new ArrayList<Task<? extends Serializable>>();
        if (nns.isEmpty()) {
            return tasks;
        }
        String actualDbName = context.isDbNameEmpty() ? nns.get(0).getTable_db() : context.dbName;
        String actualTblName = context.isTableNameEmpty() ? nns.get(0).getTable_name() : context.tableName;
        for (SQLNotNullConstraint nn : nns) {
            nn.setTable_db(actualDbName);
            nn.setTable_name(actualTblName);
        }
        AlterTableDesc addConstraintsDesc = new AlterTableDesc(actualDbName + "." + actualTblName, new ArrayList<SQLPrimaryKey>(), new ArrayList<SQLForeignKey>(), new ArrayList<SQLUniqueConstraint>(), nns, new ArrayList<SQLDefaultConstraint>(), new ArrayList<SQLCheckConstraint>(), context.eventOnlyReplicationSpec());
        Task<DDLWork> addConstraintsTask = TaskFactory.get(new DDLWork((HashSet<ReadEntity>)this.readEntitySet, (HashSet<WriteEntity>)this.writeEntitySet, addConstraintsDesc), context.hiveConf);
        tasks.add(addConstraintsTask);
        context.log.debug("Added add constrains task : {}:{}", (Object)addConstraintsTask.getId(), (Object)actualTblName);
        this.updatedMetadata.set(context.dmd.getEventTo().toString(), actualDbName, actualTblName, null);
        return Collections.singletonList(addConstraintsTask);
    }
}

