/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.AbstractTransformer;
import org.apache.hadoop.hive.ql.udf.generic.AbstractTransformerAdapter;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.ShortObjectInspector;

class ShortTransformerAdapter
extends AbstractTransformerAdapter {
    final ShortObjectInspector columnType;
    final ShortWritable writable;

    public ShortTransformerAdapter(ShortObjectInspector columnType, AbstractTransformer transformer) {
        this(columnType, transformer, new ShortWritable());
    }

    public ShortTransformerAdapter(ShortObjectInspector columnType, AbstractTransformer transformer, ShortWritable writable) {
        super(transformer);
        this.columnType = columnType;
        this.writable = writable;
    }

    @Override
    public Object getTransformedWritable(GenericUDF.DeferredObject object) throws HiveException {
        Short transformedValue;
        Short value = (Short)this.columnType.getPrimitiveJavaObject(object.get());
        if (value != null && (transformedValue = this.transformer.transform(value)) != null) {
            this.writable.set(transformedValue);
            return this.writable;
        }
        return null;
    }
}

