/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ComponentHelper;
import org.apache.tools.ant.Evaluable;
import org.apache.tools.ant.IntrospectionHelper;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.PropertyHelper;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.TypeAdapter;
import org.apache.tools.ant.UnknownElement;
import org.apache.tools.ant.UnsupportedAttributeException;
import org.apache.tools.ant.attribute.EnableAttribute;
import org.apache.tools.ant.taskdefs.MacroDef;
import org.apache.tools.ant.taskdefs.MacroInstance;
import org.apache.tools.ant.util.CollectionUtils;
import org.xml.sax.AttributeList;
import org.xml.sax.helpers.AttributeListImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuntimeConfigurable
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Hashtable<String, Object> EMPTY_HASHTABLE = new Hashtable(0);
    private String elementTag = null;
    private List<RuntimeConfigurable> children = null;
    private transient Object wrappedObject = null;
    private transient AttributeList attributes;
    private transient boolean namespacedAttribute = false;
    private LinkedHashMap<String, Object> attributeMap = null;
    private StringBuffer characters = null;
    private boolean proxyConfigured = false;
    private String polyType = null;
    private String id = null;

    public RuntimeConfigurable(Object proxy, String elementTag) {
        this.setProxy(proxy);
        this.setElementTag(elementTag);
        if (proxy instanceof Task) {
            ((Task)proxy).setRuntimeConfigurableWrapper(this);
        }
    }

    public synchronized void setProxy(Object proxy) {
        this.wrappedObject = proxy;
        this.proxyConfigured = false;
    }

    public boolean isEnabled(UnknownElement owner) {
        if (!this.namespacedAttribute) {
            return true;
        }
        ComponentHelper componentHelper = ComponentHelper.getComponentHelper(owner.getProject());
        IntrospectionHelper ih = IntrospectionHelper.getHelper(owner.getProject(), EnableAttributeConsumer.class);
        for (int i = 0; i < this.attributeMap.keySet().size(); ++i) {
            String componentName;
            String ns;
            String name = (String)this.attributeMap.keySet().toArray()[i];
            if (name.indexOf(58) == -1 || componentHelper.getRestrictedDefinitions(ProjectHelper.nsToComponentName(ns = ProjectHelper.extractUriFromComponentName(componentName = this.attrToComponent(name)))) == null) continue;
            String value = (String)this.attributeMap.get(name);
            EnableAttribute enable = null;
            try {
                enable = (EnableAttribute)ih.createElement(owner.getProject(), new EnableAttributeConsumer(), componentName);
            }
            catch (BuildException ex) {
                throw new BuildException("Unsupported attribute " + componentName);
            }
            if (enable == null || enable.isEnabled(owner, value = owner.getProject().replaceProperties(value))) continue;
            return false;
        }
        return true;
    }

    private String attrToComponent(String a) {
        int p1 = a.lastIndexOf(58);
        int p2 = a.lastIndexOf(58, p1 - 1);
        return a.substring(0, p2) + a.substring(p1);
    }

    synchronized void setCreator(IntrospectionHelper.Creator creator) {
    }

    public synchronized Object getProxy() {
        return this.wrappedObject;
    }

    public synchronized String getId() {
        return this.id;
    }

    public synchronized String getPolyType() {
        return this.polyType;
    }

    public synchronized void setPolyType(String polyType) {
        this.polyType = polyType;
    }

    public synchronized void setAttributes(AttributeList attributes) {
        this.attributes = new AttributeListImpl(attributes);
        for (int i = 0; i < attributes.getLength(); ++i) {
            this.setAttribute(attributes.getName(i), attributes.getValue(i));
        }
    }

    public synchronized void setAttribute(String name, String value) {
        if (name.indexOf(58) != -1) {
            this.namespacedAttribute = true;
        }
        this.setAttribute(name, (Object)value);
    }

    public synchronized void setAttribute(String name, Object value) {
        if (name.equalsIgnoreCase("ant-type")) {
            this.polyType = value == null ? null : value.toString();
        } else {
            if (this.attributeMap == null) {
                this.attributeMap = new LinkedHashMap();
            }
            if (name.equalsIgnoreCase("refid") && !this.attributeMap.isEmpty()) {
                LinkedHashMap<String, Object> newAttributeMap = new LinkedHashMap<String, Object>();
                newAttributeMap.put(name, value);
                newAttributeMap.putAll(this.attributeMap);
                this.attributeMap = newAttributeMap;
            } else {
                this.attributeMap.put(name, value);
            }
            if (name.equals("id")) {
                this.id = value == null ? null : value.toString();
            }
        }
    }

    public synchronized void removeAttribute(String name) {
        this.attributeMap.remove(name);
    }

    public synchronized Hashtable<String, Object> getAttributeMap() {
        return this.attributeMap == null ? EMPTY_HASHTABLE : new Hashtable<String, Object>(this.attributeMap);
    }

    public synchronized AttributeList getAttributes() {
        return this.attributes;
    }

    public synchronized void addChild(RuntimeConfigurable child) {
        this.children = this.children == null ? new ArrayList() : this.children;
        this.children.add(child);
    }

    synchronized RuntimeConfigurable getChild(int index) {
        return this.children.get(index);
    }

    public synchronized Enumeration<RuntimeConfigurable> getChildren() {
        return this.children == null ? new CollectionUtils.EmptyEnumeration() : Collections.enumeration(this.children);
    }

    public synchronized void addText(String data) {
        if (data.length() == 0) {
            return;
        }
        this.characters = this.characters == null ? new StringBuffer(data) : this.characters.append(data);
    }

    public synchronized void addText(char[] buf, int start, int count) {
        if (count == 0) {
            return;
        }
        this.characters = (this.characters == null ? new StringBuffer(count) : this.characters).append(buf, start, count);
    }

    public synchronized StringBuffer getText() {
        return this.characters == null ? new StringBuffer(0) : this.characters;
    }

    public synchronized void setElementTag(String elementTag) {
        this.elementTag = elementTag;
    }

    public synchronized String getElementTag() {
        return this.elementTag;
    }

    public void maybeConfigure(Project p) throws BuildException {
        this.maybeConfigure(p, true);
    }

    public synchronized void maybeConfigure(Project p, boolean configureChildren) throws BuildException {
        if (this.proxyConfigured) {
            return;
        }
        Object target = this.wrappedObject instanceof TypeAdapter ? ((TypeAdapter)this.wrappedObject).getProxy() : this.wrappedObject;
        IntrospectionHelper ih = IntrospectionHelper.getHelper(p, target.getClass());
        if (this.attributeMap != null) {
            for (Map.Entry<String, Object> entry : this.attributeMap.entrySet()) {
                String name = entry.getKey();
                Object value = entry.getValue();
                Object attrValue = value instanceof Evaluable ? ((Evaluable)value).eval() : PropertyHelper.getPropertyHelper(p).parseProperties(value.toString());
                if (target instanceof MacroInstance) {
                    for (MacroDef.Attribute attr : ((MacroInstance)target).getMacroDef().getAttributes()) {
                        if (!attr.getName().equals(name)) continue;
                        if (attr.isDoubleExpanding()) break;
                        attrValue = value;
                        break;
                    }
                }
                try {
                    ih.setAttribute(p, target, name, attrValue);
                }
                catch (UnsupportedAttributeException be) {
                    if (name.equals("id")) continue;
                    if (this.getElementTag() == null) {
                        throw be;
                    }
                    throw new BuildException(this.getElementTag() + " doesn't support the \"" + be.getAttribute() + "\" attribute", be);
                }
                catch (BuildException be) {
                    if (name.equals("id")) continue;
                    throw be;
                }
            }
        }
        if (this.characters != null) {
            ProjectHelper.addText(p, this.wrappedObject, this.characters.substring(0));
        }
        if (this.id != null) {
            p.addReference(this.id, this.wrappedObject);
        }
        this.proxyConfigured = true;
    }

    public void reconfigure(Project p) {
        this.proxyConfigured = false;
        this.maybeConfigure(p);
    }

    public void applyPreSet(RuntimeConfigurable r) {
        if (r.attributeMap != null) {
            for (String name : r.attributeMap.keySet()) {
                if (this.attributeMap != null && this.attributeMap.get(name) != null) continue;
                this.setAttribute(name, (String)r.attributeMap.get(name));
            }
        }
        String string = this.polyType = this.polyType == null ? r.polyType : this.polyType;
        if (r.children != null) {
            ArrayList<RuntimeConfigurable> newChildren = new ArrayList<RuntimeConfigurable>();
            newChildren.addAll(r.children);
            if (this.children != null) {
                newChildren.addAll(this.children);
            }
            this.children = newChildren;
        }
        if (r.characters != null && (this.characters == null || this.characters.toString().trim().length() == 0)) {
            this.characters = new StringBuffer(r.characters.toString());
        }
    }

    private static class EnableAttributeConsumer {
        private EnableAttributeConsumer() {
        }

        public void add(EnableAttribute b) {
        }
    }
}

