/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.formatter.kgdumper;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.apache.hugegraph.formatter.Formatter;
import org.apache.hugegraph.formatter.kgdumper.ComputeSign;
import org.apache.hugegraph.structure.JsonGraph;

public class DumpKGFormatter
implements Formatter {
    private ComputeSign cs = new ComputeSign("./trade_value", "GBK");
    private static final String ENTITY_FORMAT = "%s\t%s\t%s\t%s\t%d\t%s\t%s\t%s\t%s\t%s\t%s\t\t\t";
    private static final String MENTION_FORMAT = "%s\t%s\t%s";

    @Override
    public String dump(JsonGraph.JsonVertex vertex) throws Exception {
        switch (vertex.getLabel()) {
            case "entity": {
                return this.dumpEntity(vertex);
            }
            case "mention": {
                return this.dumpMemtion(vertex);
            }
        }
        return "";
    }

    private String dumpEntity(JsonGraph.JsonVertex vertex) throws UnsupportedEncodingException {
        if (vertex == null) {
            return "";
        }
        Set<JsonGraph.JsonEdge> edges = vertex.getEdges();
        Map<String, Object> properties = vertex.properties();
        String plainId = (String)properties.get("plain_id");
        String seqPlainId = this.cs.computeSeqNum(plainId);
        String value = (String)properties.get("value");
        String key = (String)properties.get("key");
        double weight = (Double)properties.get("weight");
        int type = (Integer)properties.get("type");
        ArrayList<String> parent = new ArrayList<String>();
        ArrayList<String> parentWeight = new ArrayList<String>();
        ArrayList<String> child = new ArrayList<String>();
        ArrayList<String> childWeight = new ArrayList<String>();
        ArrayList<String> region = new ArrayList<String>();
        ArrayList<String> regionWeight = new ArrayList<String>();
        for (JsonGraph.JsonEdge edge : edges) {
            if (edge == null || !vertex.getId().equals(edge.getSource())) continue;
            Map<String, Object> props = edge.properties();
            switch (edge.getLabel()) {
                case "is": {
                    parent.add(((String)edge.getTarget()).split(":", 2)[1]);
                    parentWeight.add(props.get("weight").toString());
                    break;
                }
                case "has": {
                    child.add(((String)edge.getTarget()).split(":", 2)[1]);
                    childWeight.add(props.get("weight").toString());
                    break;
                }
                case "region": {
                    region.add(((String)edge.getTarget()).split(":", 2)[1]);
                    regionWeight.add(props.get("weight").toString());
                    break;
                }
            }
        }
        return String.format(ENTITY_FORMAT, seqPlainId, value, key, weight, type, String.join((CharSequence)"|*|", parent), String.join((CharSequence)"|*|", parentWeight), String.join((CharSequence)"|*|", child), String.join((CharSequence)"|*|", childWeight), String.join((CharSequence)"|*|", region), String.join((CharSequence)"|*|", regionWeight));
    }

    private String dumpMemtion(JsonGraph.JsonVertex vertex) throws UnsupportedEncodingException {
        if (vertex == null) {
            return "";
        }
        Set<JsonGraph.JsonEdge> edges = vertex.getEdges();
        String value = (String)vertex.properties().get("value");
        ArrayList<String> descript = new ArrayList<String>();
        ArrayList<String> descriptWeight = new ArrayList<String>();
        for (JsonGraph.JsonEdge edge : edges) {
            if (!vertex.getId().equals(edge.getSource()) || !edge.getLabel().equals("describe")) continue;
            String plainId = ((String)edge.getTarget()).split(":", 2)[1];
            String seqPlainId = this.cs.computeSeqNum(plainId);
            descript.add(seqPlainId);
            descriptWeight.add(edge.properties().get("confidence").toString());
        }
        return String.format(MENTION_FORMAT, value, String.join((CharSequence)"|*|", descript), String.join((CharSequence)"|*|", descriptWeight));
    }
}

