/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.jvmtool.stacktrace;

import java.io.IOException;
import org.gridkit.jvmtool.codec.stacktrace.ThreadSnapshotEvent;
import org.gridkit.jvmtool.event.Event;
import org.gridkit.jvmtool.event.EventReader;
import org.gridkit.jvmtool.event.ShieldedEventReader;
import org.gridkit.jvmtool.stacktrace.CounterCollection;
import org.gridkit.jvmtool.stacktrace.StackFrameList;
import org.gridkit.jvmtool.stacktrace.StackTraceReader;

public class LegacyStackReader
implements StackTraceReader {
    private EventReader<ThreadSnapshotEvent> events;

    public LegacyStackReader(EventReader<? extends Event> source) {
        this.events = new ShieldedEventReader<ThreadSnapshotEvent>(source, ThreadSnapshotEvent.class);
    }

    @Override
    public boolean isLoaded() {
        return this.events.hasNext();
    }

    @Override
    public long getThreadId() {
        return this.events.peekNext().threadId();
    }

    @Override
    public long getTimestamp() {
        return this.events.peekNext().timestamp();
    }

    @Override
    public String getThreadName() {
        return this.events.peekNext().threadName();
    }

    @Override
    public Thread.State getThreadState() {
        return this.events.peekNext().threadState();
    }

    @Override
    public CounterCollection getCounters() {
        return this.events.peekNext().counters();
    }

    @Override
    public StackTraceElement[] getTrace() {
        StackFrameList list = this.events.peekNext().stackTrace();
        if (list == null) {
            return null;
        }
        StackTraceElement[] strace = new StackTraceElement[list.depth()];
        for (int i = 0; i != strace.length; ++i) {
            strace[i] = list.frameAt(i).toStackTraceElement();
        }
        return strace;
    }

    @Override
    public StackFrameList getStackTrace() {
        return this.events.peekNext().stackTrace();
    }

    @Override
    public boolean loadNext() throws IOException {
        if (this.events.hasNext()) {
            this.events.next();
        }
        return this.events.hasNext();
    }
}

