/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.auth;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.hugegraph.HugeGraphParams;
import org.apache.hugegraph.auth.ResourceType;
import org.apache.hugegraph.auth.SchemaDefine;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.backend.id.IdGenerator;
import org.apache.hugegraph.schema.VertexLabel;
import org.apache.hugegraph.util.E;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.T;

public class HugeRole
extends SchemaDefine.Entity {
    private static final long serialVersionUID = 2330399818352242686L;
    private String name;
    private String nickname;
    private String graphSpace;
    private String description;

    public HugeRole(Id id, String name, String graphSpace) {
        this.id = id;
        this.name = name;
        this.graphSpace = graphSpace;
        this.description = null;
    }

    public HugeRole(String name, String graphSpace) {
        this(StringUtils.isNotEmpty((CharSequence)name) ? IdGenerator.of(name) : null, name, graphSpace);
    }

    public HugeRole(Id id, String graphSpace) {
        this(id, id.asString(), graphSpace);
    }

    public static HugeRole fromMap(Map<String, Object> map) {
        HugeRole role = new HugeRole("", "");
        return HugeRole.fromMap(map, role);
    }

    public static Schema schema(HugeGraphParams graph) {
        return new Schema(graph);
    }

    @Override
    public ResourceType type() {
        return ResourceType.GRANT;
    }

    @Override
    public String label() {
        return P.ROLE;
    }

    @Override
    public String name() {
        return this.name;
    }

    public void name(String name) {
        this.name = name;
    }

    public String nickname() {
        return this.nickname;
    }

    public void nickname(String nickname) {
        this.nickname = nickname;
    }

    public String graphSpace() {
        return this.graphSpace;
    }

    public String description() {
        return this.description;
    }

    public void description(String description) {
        this.description = description;
    }

    public String toString() {
        return String.format("HugeGroup(%s)", this.id);
    }

    @Override
    protected boolean property(String key, Object value) {
        if (super.property(key, value)) {
            return true;
        }
        switch (key) {
            case "~graphspace": {
                this.graphSpace = (String)value;
                break;
            }
            case "~role_name": {
                this.name = (String)value;
                break;
            }
            case "~role_nickname": {
                this.nickname = (String)value;
                break;
            }
            case "~role_description": {
                this.description = (String)value;
                break;
            }
            default: {
                throw new AssertionError((Object)("Unsupported key: " + key));
            }
        }
        return true;
    }

    @Override
    protected Object[] asArray() {
        E.checkState((this.name != null ? 1 : 0) != 0, (String)"Group name can't be null", (Object[])new Object[0]);
        ArrayList<Object> list = new ArrayList<Object>(12);
        list.add(T.label);
        list.add(P.ROLE);
        list.add("~graphspace");
        list.add(this.graphSpace);
        list.add("~role_name");
        list.add(this.name);
        if (this.nickname != null) {
            list.add("~role_nickname");
            list.add(this.nickname);
        }
        if (this.description != null) {
            list.add("~role_description");
            list.add(this.description);
        }
        return super.asArray(list);
    }

    @Override
    public Map<String, Object> asMap() {
        E.checkState((this.name != null ? 1 : 0) != 0, (String)"Group name can't be null", (Object[])new Object[0]);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(Graph.Hidden.unHide((String)"~role_name"), this.name);
        map.put(Graph.Hidden.unHide((String)"~graphspace"), this.graphSpace);
        if (this.description != null) {
            map.put(Graph.Hidden.unHide((String)"~role_description"), this.description);
        }
        if (this.nickname != null) {
            map.put(Graph.Hidden.unHide((String)"~role_nickname"), this.nickname);
        }
        return super.asMap(map);
    }

    public static final class Schema
    extends SchemaDefine {
        public Schema(HugeGraphParams graph) {
            super(graph, P.ROLE);
        }

        @Override
        public void initSchemaIfNeeded() {
            if (this.existVertexLabel(this.label)) {
                return;
            }
            String[] properties = this.initProperties();
            VertexLabel label = (VertexLabel)this.schema().vertexLabel(this.label).properties(properties).usePrimaryKeyId().primaryKeys("~role_name").nullableKeys("~role_description", "~role_nickname").enableLabelIndex(true).build();
            this.graph.schemaTransaction().addVertexLabel(label);
        }

        protected String[] initProperties() {
            ArrayList<String> props = new ArrayList<String>();
            props.add(this.createPropertyKey("~role_name"));
            props.add(this.createPropertyKey("~role_description"));
            props.add(this.createPropertyKey("~role_nickname"));
            return super.initProperties(props);
        }
    }

    public static final class P {
        public static final String ROLE = Graph.Hidden.hide((String)"role");
        public static final String ID = T.id.getAccessor();
        public static final String LABEL = T.label.getAccessor();
        public static final String NAME = "~role_name";
        public static final String NICKNAME = "~role_nickname";
        public static final String GRAPHSPACE = "~graphspace";
        public static final String DESCRIPTION = "~role_description";

        public static String unhide(String key) {
            String prefix = Graph.Hidden.hide((String)"role_");
            if (key.startsWith(prefix)) {
                return key.substring(prefix.length());
            }
            return key;
        }
    }
}

