/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.backend.cache;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.apache.hugegraph.HugeGraphParams;
import org.apache.hugegraph.backend.cache.Cache;
import org.apache.hugegraph.backend.cache.CacheManager;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.backend.id.IdGenerator;
import org.apache.hugegraph.backend.store.ram.IntObjectMap;
import org.apache.hugegraph.backend.tx.SchemaTransactionV2;
import org.apache.hugegraph.config.CoreOptions;
import org.apache.hugegraph.event.Event;
import org.apache.hugegraph.event.EventHub;
import org.apache.hugegraph.event.EventListener;
import org.apache.hugegraph.meta.MetaDriver;
import org.apache.hugegraph.meta.MetaManager;
import org.apache.hugegraph.perf.PerfUtil;
import org.apache.hugegraph.schema.SchemaElement;
import org.apache.hugegraph.type.HugeType;
import org.apache.hugegraph.util.E;

public class CachedSchemaTransactionV2
extends SchemaTransactionV2 {
    private final Cache<Id, Object> idCache;
    private final Cache<Id, Object> nameCache;
    private final SchemaCaches<SchemaElement> arrayCaches;
    private EventListener storeEventListener;
    private EventListener cacheEventListener;

    public CachedSchemaTransactionV2(MetaDriver metaDriver, String cluster, HugeGraphParams graphParams) {
        super(metaDriver, cluster, graphParams);
        long capacity = (Long)graphParams.configuration().get(CoreOptions.SCHEMA_CACHE_CAPACITY);
        this.idCache = this.cache("schema-id", capacity);
        this.nameCache = this.cache("schema-name", capacity);
        SchemaCaches attachment = (SchemaCaches)this.idCache.attachment();
        if (attachment == null) {
            int acSize = (int)(capacity >> 3);
            attachment = this.idCache.attachment(new SchemaCaches(acSize));
        }
        this.arrayCaches = attachment;
        this.listenChanges();
    }

    private static Id generateId(HugeType type, Id id) {
        return IdGenerator.of(type.string() + "-" + id.asString());
    }

    private static Id generateId(HugeType type, String name) {
        return IdGenerator.of(type.string() + "-" + name);
    }

    @Override
    public void close() {
        this.clearCache(false);
        this.unlistenChanges();
    }

    private Cache<Id, Object> cache(String prefix, long capacity) {
        String name = prefix + "-" + this.graphName();
        return CacheManager.instance().cache(name, capacity);
    }

    private void listenChanges() {
        ImmutableSet storeEvents = ImmutableSet.of((Object)"store.init", (Object)"store.clear", (Object)"store.truncate");
        this.storeEventListener = arg_0 -> this.lambda$listenChanges$0((Set)storeEvents, arg_0);
        this.graphParams().loadGraphStore().provider().listen(this.storeEventListener);
        this.cacheEventListener = event -> {
            LOG.debug("Graph {} received schema cache event: {}", (Object)this.graph(), (Object)event);
            Object[] args = event.args();
            E.checkArgument((args.length > 0 && args[0] instanceof String ? 1 : 0) != 0, (String)"Expect event action argument", (Object[])new Object[0]);
            if ("invalid".equals(args[0])) {
                event.checkArgs(new Class[]{String.class, HugeType.class, Id.class});
                HugeType type = (HugeType)args[1];
                Id id = (Id)args[2];
                this.arrayCaches.remove(type, id);
                id = CachedSchemaTransactionV2.generateId(type, id);
                Object value = this.idCache.get(id);
                if (value != null) {
                    this.idCache.invalidate(id);
                    SchemaElement schema = (SchemaElement)value;
                    Id prefixedName = CachedSchemaTransactionV2.generateId(schema.type(), schema.name());
                    this.nameCache.invalidate(prefixedName);
                }
                this.resetCachedAll(type);
                return true;
            }
            if ("clear".equals(args[0])) {
                event.checkArgs(new Class[]{String.class, HugeType.class});
                this.clearCache(false);
                return true;
            }
            return false;
        };
        EventHub schemaEventHub = this.graphParams().schemaEventHub();
        if (!schemaEventHub.containsListener("cache")) {
            schemaEventHub.listen("cache", this.cacheEventListener);
        }
    }

    public void clearCache(boolean notify) {
        this.idCache.clear();
        this.nameCache.clear();
        this.arrayCaches.clear();
    }

    private void resetCachedAllIfReachedCapacity() {
        if (this.idCache.size() >= this.idCache.capacity()) {
            LOG.warn("Schema cache reached capacity({}): {}", (Object)this.idCache.capacity(), (Object)this.idCache.size());
            this.cachedTypes().clear();
        }
    }

    private void unlistenChanges() {
        this.graphParams().loadGraphStore().provider().unlisten(this.storeEventListener);
        EventHub schemaEventHub = this.graphParams().schemaEventHub();
        schemaEventHub.unlisten("cache", this.cacheEventListener);
    }

    private CachedTypes cachedTypes() {
        return this.arrayCaches.cachedTypes();
    }

    private void resetCachedAll(HugeType type) {
        this.cachedTypes().put(type, false);
    }

    private void invalidateCache(HugeType type, Id id) {
        Id prefixedId = CachedSchemaTransactionV2.generateId(type, id);
        Object value = this.idCache.get(prefixedId);
        if (value != null) {
            this.idCache.invalidate(prefixedId);
            SchemaElement schema = (SchemaElement)value;
            Id prefixedName = CachedSchemaTransactionV2.generateId(schema.type(), schema.name());
            this.nameCache.invalidate(prefixedName);
        }
        this.arrayCaches.remove(type, id);
    }

    @Override
    protected void updateSchema(SchemaElement schema, Consumer<SchemaElement> updateCallback) {
        super.updateSchema(schema, updateCallback);
        this.updateCache(schema);
    }

    @Override
    protected void addSchema(SchemaElement schema) {
        super.addSchema(schema);
        this.updateCache(schema);
        if (!((Boolean)this.graph().option(CoreOptions.TASK_SYNC_DELETION)).booleanValue()) {
            MetaManager.instance().notifySchemaCacheClear("", this.graph().name());
        }
    }

    private void updateCache(SchemaElement schema) {
        this.resetCachedAllIfReachedCapacity();
        Id prefixedId = CachedSchemaTransactionV2.generateId(schema.type(), schema.id());
        this.idCache.update(prefixedId, schema);
        Id prefixedName = CachedSchemaTransactionV2.generateId(schema.type(), schema.name());
        this.nameCache.update(prefixedName, schema);
        this.arrayCaches.updateIfNeeded(schema);
    }

    @Override
    public void removeSchema(SchemaElement schema) {
        super.removeSchema(schema);
        this.invalidateCache(schema.type(), schema.id());
        if (!((Boolean)this.graph().option(CoreOptions.TASK_SYNC_DELETION)).booleanValue()) {
            MetaManager.instance().notifySchemaCacheClear("", this.graph().name());
        }
    }

    @Override
    protected <T extends SchemaElement> T getSchema(HugeType type, Id id) {
        SchemaElement value;
        if (id.number() && id.asLong() > 0L && (value = this.arrayCaches.get(type, id)) != null) {
            return (T)value;
        }
        Id prefixedId = CachedSchemaTransactionV2.generateId(type, id);
        Object value2 = this.idCache.get(prefixedId);
        if (value2 == null && (value2 = super.getSchema(type, id)) != null) {
            this.resetCachedAllIfReachedCapacity();
            this.idCache.update(prefixedId, value2);
            SchemaElement schema = (SchemaElement)value2;
            Id prefixedName = CachedSchemaTransactionV2.generateId(schema.type(), schema.name());
            this.nameCache.update(prefixedName, schema);
        }
        this.arrayCaches.updateIfNeeded((SchemaElement)value2);
        return (T)((SchemaElement)value2);
    }

    @Override
    protected <T extends SchemaElement> T getSchema(HugeType type, String name) {
        Id prefixedName = CachedSchemaTransactionV2.generateId(type, name);
        Object value = this.nameCache.get(prefixedName);
        if (value == null && (value = super.getSchema(type, name)) != null) {
            this.clearCache(false);
            this.loadAllSchema();
        }
        return (T)((SchemaElement)value);
    }

    @Override
    protected <T extends SchemaElement> List<T> getAllSchema(HugeType type) {
        Boolean cachedAll = this.cachedTypes().getOrDefault(type, false);
        if (cachedAll.booleanValue()) {
            ArrayList results = new ArrayList();
            this.idCache.traverse(value -> {
                SchemaElement schema = (SchemaElement)value;
                if (schema.type() == type) {
                    results.add(schema);
                }
            });
            return results;
        }
        List results = super.getAllSchema(type);
        long free = this.idCache.capacity() - this.idCache.size();
        if ((long)results.size() <= free) {
            for (SchemaElement schema : results) {
                Id prefixedId = CachedSchemaTransactionV2.generateId(schema.type(), schema.id());
                this.idCache.update(prefixedId, schema);
                Id prefixedName = CachedSchemaTransactionV2.generateId(schema.type(), schema.name());
                this.nameCache.update(prefixedName, schema);
            }
            this.cachedTypes().putIfAbsent(type, true);
        }
        return results;
    }

    private void loadAllSchema() {
        this.getAllSchema(HugeType.PROPERTY_KEY);
        this.getAllSchema(HugeType.VERTEX_LABEL);
        this.getAllSchema(HugeType.EDGE_LABEL);
        this.getAllSchema(HugeType.INDEX_LABEL);
    }

    @Override
    public void clear() {
        super.clear();
        this.clearCache(false);
    }

    private /* synthetic */ Object lambda$listenChanges$0(Set storeEvents, Event event) {
        if (storeEvents.contains(event.name())) {
            LOG.debug("Graph {} clear schema cache on event '{}'", (Object)this.graph(), (Object)event.name());
            this.clearCache(true);
            return true;
        }
        return false;
    }

    private static class CachedTypes
    extends ConcurrentHashMap<HugeType, Boolean> {
        private static final long serialVersionUID = -2215549791679355996L;

        private CachedTypes() {
        }
    }

    private static final class SchemaCaches<V extends SchemaElement> {
        private final int size;
        private final IntObjectMap<V> pks;
        private final IntObjectMap<V> vls;
        private final IntObjectMap<V> els;
        private final IntObjectMap<V> ils;
        private final CachedTypes cachedTypes;

        public SchemaCaches(int size) {
            this.size = size;
            this.pks = new IntObjectMap(size);
            this.vls = new IntObjectMap(size);
            this.els = new IntObjectMap(size);
            this.ils = new IntObjectMap(size);
            this.cachedTypes = new CachedTypes();
        }

        public void updateIfNeeded(V schema) {
            if (schema == null) {
                return;
            }
            Id id = ((SchemaElement)schema).id();
            if (id.number() && id.asLong() > 0L) {
                this.set(schema.type(), id, schema);
            }
        }

        @PerfUtil.Watched
        public V get(HugeType type, Id id) {
            assert (id.number());
            long longId = id.asLong();
            if (longId <= 0L) {
                assert (false) : id;
                return null;
            }
            int key = (int)longId;
            if (key >= this.size) {
                return null;
            }
            switch (type) {
                case PROPERTY_KEY: {
                    return (V)((SchemaElement)this.pks.get(key));
                }
                case VERTEX_LABEL: {
                    return (V)((SchemaElement)this.vls.get(key));
                }
                case EDGE_LABEL: {
                    return (V)((SchemaElement)this.els.get(key));
                }
                case INDEX_LABEL: {
                    return (V)((SchemaElement)this.ils.get(key));
                }
            }
            return null;
        }

        public void set(HugeType type, Id id, V value) {
            assert (id.number());
            long longId = id.asLong();
            if (longId <= 0L) {
                assert (false) : id;
                return;
            }
            int key = (int)longId;
            if (key >= this.size) {
                return;
            }
            switch (type) {
                case PROPERTY_KEY: {
                    this.pks.set(key, value);
                    break;
                }
                case VERTEX_LABEL: {
                    this.vls.set(key, value);
                    break;
                }
                case EDGE_LABEL: {
                    this.els.set(key, value);
                    break;
                }
                case INDEX_LABEL: {
                    this.ils.set(key, value);
                    break;
                }
            }
        }

        public void remove(HugeType type, Id id) {
            assert (id.number());
            long longId = id.asLong();
            if (longId <= 0L) {
                return;
            }
            int key = (int)longId;
            Object value = null;
            if (key >= this.size) {
                return;
            }
            switch (type) {
                case PROPERTY_KEY: {
                    this.pks.set(key, value);
                    break;
                }
                case VERTEX_LABEL: {
                    this.vls.set(key, value);
                    break;
                }
                case EDGE_LABEL: {
                    this.els.set(key, value);
                    break;
                }
                case INDEX_LABEL: {
                    this.ils.set(key, value);
                    break;
                }
            }
        }

        public void clear() {
            this.pks.clear();
            this.vls.clear();
            this.els.clear();
            this.ils.clear();
            this.cachedTypes.clear();
        }

        public CachedTypes cachedTypes() {
            return this.cachedTypes;
        }
    }
}

