/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.meta.managers;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hugegraph.HugeGraph;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.backend.id.IdGenerator;
import org.apache.hugegraph.meta.MetaDriver;
import org.apache.hugegraph.meta.PdMetaDriver;
import org.apache.hugegraph.meta.managers.AbstractMetaManager;
import org.apache.hugegraph.schema.EdgeLabel;
import org.apache.hugegraph.schema.IndexLabel;
import org.apache.hugegraph.schema.PropertyKey;
import org.apache.hugegraph.schema.VertexLabel;
import org.apache.hugegraph.util.JsonUtil;

public class SchemaMetaManager
extends AbstractMetaManager {
    private final HugeGraph graph;

    public SchemaMetaManager(MetaDriver metaDriver, String cluster, HugeGraph graph) {
        super(metaDriver, cluster);
        this.graph = graph;
    }

    public static void main(String[] args) {
        PdMetaDriver metaDriver = new PdMetaDriver("127.0.0.1:8686");
        SchemaMetaManager schemaMetaManager = new SchemaMetaManager(metaDriver, "hg", null);
        PropertyKey propertyKey = new PropertyKey(null, IdGenerator.of(5L), "test");
        propertyKey.userdata("key1", "value1");
        propertyKey.userdata("key2", 23);
        schemaMetaManager.addPropertyKey("DEFAULT1", "hugegraph", propertyKey);
        schemaMetaManager.removePropertyKey("DEFAULT", "hugegraph", IdGenerator.of(1L));
    }

    public void addPropertyKey(String graphSpace, String graph, PropertyKey propertyKey) {
        String content = SchemaMetaManager.serialize(propertyKey);
        this.metaDriver.put(this.propertyKeyIdKey(graphSpace, graph, propertyKey.id()), content);
        this.metaDriver.put(this.propertyKeyNameKey(graphSpace, graph, propertyKey.name()), content);
    }

    public void updatePropertyKey(String graphSpace, String graph, PropertyKey pkey) {
        this.addPropertyKey(graphSpace, graph, pkey);
    }

    public PropertyKey getPropertyKey(String graphSpace, String graph, Id propertyKey) {
        String content = this.metaDriver.get(this.propertyKeyIdKey(graphSpace, graph, propertyKey));
        if (content == null || content.length() == 0) {
            return null;
        }
        return PropertyKey.fromMap(JsonUtil.fromJson(content, Map.class), this.graph);
    }

    public PropertyKey getPropertyKey(String graphSpace, String graph, String propertyKey) {
        String content = this.metaDriver.get(this.propertyKeyNameKey(graphSpace, graph, propertyKey));
        if (content == null || content.length() == 0) {
            return null;
        }
        return PropertyKey.fromMap(JsonUtil.fromJson(content, Map.class), this.graph);
    }

    public List<PropertyKey> getPropertyKeys(String graphSpace, String graph) {
        Map<String, String> propertyKeysKvs = this.metaDriver.scanWithPrefix(this.propertyKeyPrefix(graphSpace, graph));
        ArrayList<PropertyKey> propertyKeys = new ArrayList<PropertyKey>(propertyKeysKvs.size());
        for (String value : propertyKeysKvs.values()) {
            propertyKeys.add(PropertyKey.fromMap(JsonUtil.fromJson(value, Map.class), this.graph));
        }
        return propertyKeys;
    }

    public Id removePropertyKey(String graphSpace, String graph, Id propertyKey) {
        PropertyKey p = this.getPropertyKey(graphSpace, graph, propertyKey);
        this.metaDriver.delete(this.propertyKeyNameKey(graphSpace, graph, p.name()));
        this.metaDriver.delete(this.propertyKeyIdKey(graphSpace, graph, propertyKey));
        return IdGenerator.ZERO;
    }

    public void addVertexLabel(String graphSpace, String graph, VertexLabel vertexLabel) {
        String content = SchemaMetaManager.serialize(vertexLabel);
        this.metaDriver.put(this.vertexLabelIdKey(graphSpace, graph, vertexLabel.id()), content);
        this.metaDriver.put(this.vertexLabelNameKey(graphSpace, graph, vertexLabel.name()), content);
    }

    public void updateVertexLabel(String graphSpace, String graph, VertexLabel vertexLabel) {
        this.addVertexLabel(graphSpace, graph, vertexLabel);
    }

    public VertexLabel getVertexLabel(String graphSpace, String graph, Id vertexLabel) {
        String content = this.metaDriver.get(this.vertexLabelIdKey(graphSpace, graph, vertexLabel));
        if (content == null || content.length() == 0) {
            return null;
        }
        return VertexLabel.fromMap(JsonUtil.fromJson(content, Map.class), this.graph);
    }

    public VertexLabel getVertexLabel(String graphSpace, String graph, String vertexLabel) {
        String content = this.metaDriver.get(this.vertexLabelNameKey(graphSpace, graph, vertexLabel));
        if (content == null || content.length() == 0) {
            return null;
        }
        return VertexLabel.fromMap(JsonUtil.fromJson(content, Map.class), this.graph);
    }

    public List<VertexLabel> getVertexLabels(String graphSpace, String graph) {
        Map<String, String> vertexLabelKvs = this.metaDriver.scanWithPrefix(this.vertexLabelPrefix(graphSpace, graph));
        ArrayList<VertexLabel> vertexLabels = new ArrayList<VertexLabel>(vertexLabelKvs.size());
        for (String value : vertexLabelKvs.values()) {
            vertexLabels.add(VertexLabel.fromMap(JsonUtil.fromJson(value, Map.class), this.graph));
        }
        return vertexLabels;
    }

    public Id removeVertexLabel(String graphSpace, String graph, Id vertexLabel) {
        VertexLabel v = this.getVertexLabel(graphSpace, graph, vertexLabel);
        this.metaDriver.delete(this.vertexLabelNameKey(graphSpace, graph, v.name()));
        this.metaDriver.delete(this.vertexLabelIdKey(graphSpace, graph, vertexLabel));
        return IdGenerator.ZERO;
    }

    public void addEdgeLabel(String graphSpace, String graph, EdgeLabel edgeLabel) {
        String content = SchemaMetaManager.serialize(edgeLabel);
        this.metaDriver.put(this.edgeLabelIdKey(graphSpace, graph, edgeLabel.id()), content);
        this.metaDriver.put(this.edgeLabelNameKey(graphSpace, graph, edgeLabel.name()), content);
    }

    public void updateEdgeLabel(String graphSpace, String graph, EdgeLabel edgeLabel) {
        this.addEdgeLabel(graphSpace, graph, edgeLabel);
    }

    public EdgeLabel getEdgeLabel(String graphSpace, String graph, Id edgeLabel) {
        String content = this.metaDriver.get(this.edgeLabelIdKey(graphSpace, graph, edgeLabel));
        if (content == null || content.length() == 0) {
            return null;
        }
        return EdgeLabel.fromMap(JsonUtil.fromJson(content, Map.class), this.graph);
    }

    public EdgeLabel getEdgeLabel(String graphSpace, String graph, String edgeLabel) {
        String content = this.metaDriver.get(this.edgeLabelNameKey(graphSpace, graph, edgeLabel));
        if (content == null || content.length() == 0) {
            return null;
        }
        return EdgeLabel.fromMap(JsonUtil.fromJson(content, Map.class), this.graph);
    }

    public List<EdgeLabel> getEdgeLabels(String graphSpace, String graph) {
        Map<String, String> edgeLabelKvs = this.metaDriver.scanWithPrefix(this.edgeLabelPrefix(graphSpace, graph));
        ArrayList<EdgeLabel> edgeLabels = new ArrayList<EdgeLabel>(edgeLabelKvs.size());
        for (String value : edgeLabelKvs.values()) {
            edgeLabels.add(EdgeLabel.fromMap(JsonUtil.fromJson(value, Map.class), this.graph));
        }
        return edgeLabels;
    }

    public Id removeEdgeLabel(String graphSpace, String graph, Id edgeLabel) {
        EdgeLabel e = this.getEdgeLabel(graphSpace, graph, edgeLabel);
        this.metaDriver.delete(this.edgeLabelNameKey(graphSpace, graph, e.name()));
        this.metaDriver.delete(this.edgeLabelIdKey(graphSpace, graph, edgeLabel));
        return IdGenerator.ZERO;
    }

    public void addIndexLabel(String graphSpace, String graph, IndexLabel indexLabel) {
        String content = SchemaMetaManager.serialize(indexLabel);
        this.metaDriver.put(this.indexLabelIdKey(graphSpace, graph, indexLabel.id()), content);
        this.metaDriver.put(this.indexLabelNameKey(graphSpace, graph, indexLabel.name()), content);
    }

    public void updateIndexLabel(String graphSpace, String graph, IndexLabel indexLabel) {
        this.addIndexLabel(graphSpace, graph, indexLabel);
    }

    public IndexLabel getIndexLabel(String graphSpace, String graph, Id indexLabel) {
        String content = this.metaDriver.get(this.indexLabelIdKey(graphSpace, graph, indexLabel));
        if (content == null || content.length() == 0) {
            return null;
        }
        return IndexLabel.fromMap(JsonUtil.fromJson(content, Map.class), this.graph);
    }

    public IndexLabel getIndexLabel(String graphSpace, String graph, String edgeLabel) {
        String content = this.metaDriver.get(this.indexLabelNameKey(graphSpace, graph, edgeLabel));
        if (content == null || content.length() == 0) {
            return null;
        }
        return IndexLabel.fromMap(JsonUtil.fromJson(content, Map.class), this.graph);
    }

    public List<IndexLabel> getIndexLabels(String graphSpace, String graph) {
        Map<String, String> indexLabelKvs = this.metaDriver.scanWithPrefix(this.indexLabelPrefix(graphSpace, graph));
        ArrayList<IndexLabel> indexLabels = new ArrayList<IndexLabel>(indexLabelKvs.size());
        for (String value : indexLabelKvs.values()) {
            indexLabels.add(IndexLabel.fromMap(JsonUtil.fromJson(value, Map.class), this.graph));
        }
        return indexLabels;
    }

    public Id removeIndexLabel(String graphSpace, String graph, Id indexLabel) {
        IndexLabel i = this.getIndexLabel(graphSpace, graph, indexLabel);
        this.metaDriver.delete(this.indexLabelNameKey(graphSpace, graph, i.name()));
        this.metaDriver.delete(this.indexLabelIdKey(graphSpace, graph, indexLabel));
        return IdGenerator.ZERO;
    }

    private String propertyKeyPrefix(String graphSpace, String graph) {
        return String.join((CharSequence)"/", "HUGEGRAPH", this.cluster, "GRAPHSPACE", graphSpace, graph, "SCHEMA", "PROPERTY_KEY", "NAME");
    }

    private String propertyKeyIdKey(String graphSpace, String graph, Id id) {
        return String.join((CharSequence)"/", "HUGEGRAPH", this.cluster, "GRAPHSPACE", graphSpace, graph, "SCHEMA", "PROPERTY_KEY", "ID", id.asString());
    }

    private String propertyKeyNameKey(String graphSpace, String graph, String name) {
        return String.join((CharSequence)"/", "HUGEGRAPH", this.cluster, "GRAPHSPACE", graphSpace, graph, "SCHEMA", "PROPERTY_KEY", "NAME", name);
    }

    private String vertexLabelPrefix(String graphSpace, String graph) {
        return String.join((CharSequence)"/", "HUGEGRAPH", this.cluster, "GRAPHSPACE", graphSpace, graph, "SCHEMA", "VERTEX_LABEL", "NAME");
    }

    private String vertexLabelIdKey(String graphSpace, String graph, Id id) {
        return String.join((CharSequence)"/", "HUGEGRAPH", this.cluster, "GRAPHSPACE", graphSpace, graph, "SCHEMA", "VERTEX_LABEL", "ID", id.asString());
    }

    private String vertexLabelNameKey(String graphSpace, String graph, String name) {
        return String.join((CharSequence)"/", "HUGEGRAPH", this.cluster, "GRAPHSPACE", graphSpace, graph, "SCHEMA", "VERTEX_LABEL", "NAME", name);
    }

    private String edgeLabelPrefix(String graphSpace, String graph) {
        return String.join((CharSequence)"/", "HUGEGRAPH", this.cluster, "GRAPHSPACE", graphSpace, graph, "SCHEMA", "EDGE_LABEL", "NAME");
    }

    private String edgeLabelIdKey(String graphSpace, String graph, Id id) {
        return String.join((CharSequence)"/", "HUGEGRAPH", this.cluster, "GRAPHSPACE", graphSpace, graph, "SCHEMA", "EDGE_LABEL", "ID", id.asString());
    }

    private String edgeLabelNameKey(String graphSpace, String graph, String name) {
        return String.join((CharSequence)"/", "HUGEGRAPH", this.cluster, "GRAPHSPACE", graphSpace, graph, "SCHEMA", "EDGE_LABEL", "NAME", name);
    }

    private String indexLabelPrefix(String graphSpace, String graph) {
        return String.join((CharSequence)"/", "HUGEGRAPH", this.cluster, "GRAPHSPACE", graphSpace, graph, "SCHEMA", "INDEX_LABEL", "NAME");
    }

    private String indexLabelIdKey(String graphSpace, String graph, Id id) {
        return String.join((CharSequence)"/", "HUGEGRAPH", this.cluster, "GRAPHSPACE", graphSpace, graph, "SCHEMA", "INDEX_LABEL", "ID", id.asString());
    }

    private String indexLabelNameKey(String graphSpace, String graph, String name) {
        return String.join((CharSequence)"/", "HUGEGRAPH", this.cluster, "GRAPHSPACE", graphSpace, graph, "SCHEMA", "INDEX_LABEL", "NAME", name);
    }

    private String graphNameKey(String graphSpace, String graph) {
        return String.join((CharSequence)"/", "HUGEGRAPH", this.cluster, "GRAPHSPACE", graphSpace, graph, "SCHEMA");
    }

    public void clearAllSchema(String graphSpace, String graph) {
        this.metaDriver.deleteWithPrefix(this.graphNameKey(graphSpace, graph));
    }
}

