/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.meta.managers;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.apache.hugegraph.meta.MetaDriver;
import org.apache.hugegraph.meta.managers.AbstractMetaManager;
import org.apache.hugegraph.space.Service;
import org.apache.hugegraph.util.JsonUtil;

public class ServiceMetaManager
extends AbstractMetaManager {
    public ServiceMetaManager(MetaDriver metaDriver, String cluster) {
        super(metaDriver, cluster);
    }

    private static String serviceName(String graphSpace, String name) {
        return String.join((CharSequence)"-", graphSpace, name);
    }

    public Map<String, Service> serviceConfigs(String graphSpace) {
        HashMap<String, Service> serviceMap = new HashMap<String, Service>();
        Map<String, String> keyValues = this.metaDriver.scanWithPrefix(this.serviceConfPrefix(graphSpace));
        for (Map.Entry<String, String> entry : keyValues.entrySet()) {
            String key = entry.getKey();
            String[] parts = key.split("/");
            serviceMap.put(parts[parts.length - 1], JsonUtil.fromJson(entry.getValue(), Service.class));
        }
        return serviceMap;
    }

    public String getServiceRawConfig(String graphSpace, String service) {
        return this.metaDriver.get(this.serviceConfKey(graphSpace, service));
    }

    public Service getServiceConfig(String graphSpace, String service) {
        String s = this.getServiceRawConfig(graphSpace, service);
        return this.parseServiceRawConfig(s);
    }

    public Service parseServiceRawConfig(String serviceRawConf) {
        return JsonUtil.fromJson(serviceRawConf, Service.class);
    }

    public void notifyServiceAdd(String graphSpace, String name) {
        this.metaDriver.put(this.serviceAddKey(), ServiceMetaManager.serviceName(graphSpace, name));
    }

    public void notifyServiceRemove(String graphSpace, String name) {
        this.metaDriver.put(this.serviceRemoveKey(), ServiceMetaManager.serviceName(graphSpace, name));
    }

    public void notifyServiceUpdate(String graphSpace, String name) {
        this.metaDriver.put(this.serviceUpdateKey(), ServiceMetaManager.serviceName(graphSpace, name));
    }

    public Service service(String graphSpace, String name) {
        String service = this.metaDriver.get(this.serviceConfKey(graphSpace, name));
        if (StringUtils.isEmpty((CharSequence)service)) {
            return null;
        }
        return JsonUtil.fromJson(service, Service.class);
    }

    public void addServiceConfig(String graphSpace, Service service) {
        this.metaDriver.put(this.serviceConfKey(graphSpace, service.name()), JsonUtil.toJson(service));
    }

    public void removeServiceConfig(String graphSpace, String service) {
        this.metaDriver.delete(this.serviceConfKey(graphSpace, service));
    }

    public void updateServiceConfig(String graphSpace, Service service) {
        this.addServiceConfig(graphSpace, service);
    }

    public <T> void listenServiceAdd(Consumer<T> consumer) {
        this.listen(this.serviceAddKey(), consumer);
    }

    public <T> void listenServiceRemove(Consumer<T> consumer) {
        this.listen(this.serviceRemoveKey(), consumer);
    }

    public <T> void listenServiceUpdate(Consumer<T> consumer) {
        this.listen(this.serviceUpdateKey(), consumer);
    }

    private String serviceConfPrefix(String graphSpace) {
        return this.serviceConfKey(graphSpace, "");
    }

    private String serviceAddKey() {
        return String.join((CharSequence)"/", "HUGEGRAPH", this.cluster, "EVENT", "SERVICE", "ADD");
    }

    private String serviceRemoveKey() {
        return String.join((CharSequence)"/", "HUGEGRAPH", this.cluster, "EVENT", "SERVICE", "REMOVE");
    }

    private String serviceUpdateKey() {
        return String.join((CharSequence)"/", "HUGEGRAPH", this.cluster, "EVENT", "SERVICE", "UPDATE");
    }

    private String serviceConfKey(String graphSpace, String name) {
        return String.join((CharSequence)"/", "HUGEGRAPH", this.cluster, "GRAPHSPACE", graphSpace, "SERVICE_CONF", name);
    }
}

