/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.store.client.grpc;

import java.util.Iterator;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.hugegraph.store.HgSeekAble;
import org.apache.hugegraph.store.client.util.HgAssert;

class SeekAbleIterator<E>
implements Iterator,
HgSeekAble {
    private final Iterator<E> iterator;
    private final Consumer<byte[]> seeker;
    private final Supplier<byte[]> positioner;

    private SeekAbleIterator(Iterator<E> iterator, Supplier<byte[]> positioner, Consumer<byte[]> seeker) {
        this.iterator = iterator;
        this.positioner = positioner;
        this.seeker = seeker;
    }

    public static <E> SeekAbleIterator of(Iterator<E> iterator, Supplier<byte[]> positioner, Consumer<byte[]> seeker) {
        HgAssert.isArgumentNotNull(iterator, "iterator");
        HgAssert.isArgumentNotNull(positioner, "positioner");
        HgAssert.isArgumentNotNull(seeker, "seeker");
        return new SeekAbleIterator<E>(iterator, positioner, seeker);
    }

    @Override
    public byte[] position() {
        return this.positioner.get();
    }

    @Override
    public void seek(byte[] position) {
        this.seeker.accept(position);
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public E next() {
        return this.iterator.next();
    }
}

