/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.stack.mutable.primitive;

import org.eclipse.collections.api.ShortIterable;
import org.eclipse.collections.api.factory.stack.primitive.MutableShortStackFactory;
import org.eclipse.collections.api.stack.primitive.MutableShortStack;
import org.eclipse.collections.impl.factory.primitive.ShortStacks;
import org.eclipse.collections.impl.stack.mutable.primitive.ShortArrayStack;
import org.eclipse.collections.impl.utility.Iterate;

public class MutableShortStackFactoryImpl
implements MutableShortStackFactory {
    public static final MutableShortStackFactory INSTANCE = new MutableShortStackFactoryImpl();

    public MutableShortStack empty() {
        return new ShortArrayStack();
    }

    public MutableShortStack of() {
        return this.empty();
    }

    public MutableShortStack with() {
        return this.empty();
    }

    public MutableShortStack of(short ... items) {
        return this.with(items);
    }

    public MutableShortStack with(short ... items) {
        if (items.length == 0) {
            return this.empty();
        }
        return ShortArrayStack.newStackWith(items);
    }

    public MutableShortStack ofAll(ShortIterable items) {
        return this.withAll(items);
    }

    public MutableShortStack withAll(ShortIterable items) {
        if (items.isEmpty()) {
            return this.empty();
        }
        return ShortArrayStack.newStack(items);
    }

    public MutableShortStack ofAll(Iterable<Short> iterable) {
        return this.withAll(iterable);
    }

    public MutableShortStack withAll(Iterable<Short> iterable) {
        MutableShortStack stack = ShortStacks.mutable.empty();
        Iterate.forEach(iterable, arg_0 -> ((MutableShortStack)stack).push(arg_0));
        return stack;
    }

    public MutableShortStack ofAllReversed(ShortIterable items) {
        return this.withAllReversed(items);
    }

    public MutableShortStack withAllReversed(ShortIterable items) {
        if (items.isEmpty()) {
            return this.empty();
        }
        return ShortArrayStack.newStackFromTopToBottom(items);
    }
}

