/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.pd.rest;

import com.google.protobuf.MessageOrBuilder;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.hugegraph.pd.common.PDException;
import org.apache.hugegraph.pd.grpc.Metapb;
import org.apache.hugegraph.pd.grpc.Pdpb;
import org.apache.hugegraph.pd.model.GraphRestRequest;
import org.apache.hugegraph.pd.model.RestApiResponse;
import org.apache.hugegraph.pd.rest.API;
import org.apache.hugegraph.pd.rest.GraphAPI;
import org.apache.hugegraph.pd.service.PDRestService;
import org.apache.hugegraph.pd.service.PDService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1"})
public class GraphAPI
extends API {
    private static final Logger log = LoggerFactory.getLogger(GraphAPI.class);
    @Autowired
    PDRestService pdRestService;
    @Autowired
    PDService pdService;

    @GetMapping(value={"/graph/partitionSizeRange"}, produces={"application/json"})
    @ResponseBody
    public RestApiResponse getPartitionSizeRange() {
        try {
            int minPartitionSize = 1;
            int maxPartitionSize = this.pdService.getStoreNodeService().getShardGroups().size();
            HashMap<String, Integer> dataMap = new HashMap<String, Integer>();
            dataMap.put("minPartitionSize", minPartitionSize);
            dataMap.put("maxPartitionSize", maxPartitionSize);
            return new RestApiResponse(dataMap, Pdpb.ErrorType.OK, Pdpb.ErrorType.OK.name());
        }
        catch (PDException e) {
            log.error("PDException:", (Throwable)e);
            return new RestApiResponse(null, e.getErrorCode(), e.getMessage());
        }
    }

    @GetMapping(value={"/graphs"}, produces={"application/json"})
    @ResponseBody
    public RestApiResponse getGraphs() {
        RestApiResponse response = new RestApiResponse();
        try {
            List graphs = this.pdRestService.getGraphs();
            ArrayList<GraphStatistics> resultGraphs = new ArrayList<GraphStatistics>();
            for (Metapb.Graph graph : graphs) {
                if (graph.getGraphName() == null || !graph.getGraphName().endsWith("/g")) continue;
                resultGraphs.add(new GraphStatistics(this, graph));
            }
            HashMap<String, ArrayList<GraphStatistics>> dataMap = new HashMap<String, ArrayList<GraphStatistics>>();
            dataMap.put("graphs", resultGraphs);
            response.setData(dataMap);
            response.setStatus(Pdpb.ErrorType.OK.getNumber());
            response.setMessage(Pdpb.ErrorType.OK.name());
        }
        catch (PDException e) {
            log.error("PDException: ", (Throwable)e);
            response.setData(new HashMap());
            response.setStatus(e.getErrorCode());
            response.setMessage(e.getMessage());
        }
        return response;
    }

    @PostMapping(value={"/graph/**"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseBody
    public String setGraph(@RequestBody GraphRestRequest body, HttpServletRequest request) {
        try {
            String requestURL = request.getRequestURL().toString();
            String prefix = "/graph/";
            int limit = 2;
            String graphName = requestURL.split("/graph/", 2)[1];
            graphName = URLDecoder.decode(graphName, StandardCharsets.UTF_8);
            Metapb.Graph curGraph = this.pdRestService.getGraph(graphName);
            Metapb.Graph.Builder builder = Metapb.Graph.newBuilder((Metapb.Graph)(curGraph == null ? Metapb.Graph.getDefaultInstance() : curGraph));
            builder.setGraphName(graphName);
            if (body.getPartitionCount() > 0) {
                builder.setPartitionCount(body.getPartitionCount());
            }
            Metapb.Graph newGraph = this.pdRestService.updateGraph(builder.build());
            return this.toJSON((MessageOrBuilder)newGraph, "graph");
        }
        catch (PDException exception) {
            return this.toJSON(exception);
        }
        catch (Exception e) {
            return this.toJSON(e);
        }
    }

    @GetMapping(value={"/graph/**"}, produces={"application/json"})
    @ResponseBody
    public RestApiResponse getGraph(HttpServletRequest request) throws UnsupportedEncodingException {
        RestApiResponse response = new RestApiResponse();
        GraphStatistics statistics = null;
        String requestURL = request.getRequestURL().toString();
        String prefix = "/graph/";
        int limit = 2;
        String graphName = requestURL.split("/graph/", 2)[1];
        graphName = URLDecoder.decode(graphName, StandardCharsets.UTF_8);
        try {
            Metapb.Graph graph = this.pdRestService.getGraph(graphName);
            if (graph != null) {
                statistics = new GraphStatistics(this, graph);
                response.setData((Object)statistics);
            } else {
                response.setData(new HashMap());
            }
            response.setStatus(Pdpb.ErrorType.OK.getNumber());
            response.setMessage(Pdpb.ErrorType.OK.name());
        }
        catch (PDException e) {
            log.error(e.getMessage());
            response.setData(new HashMap());
            response.setStatus(Pdpb.ErrorType.UNKNOWN.getNumber());
            response.setMessage(e.getMessage());
        }
        return response;
    }
}

