/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.pd.rest;

import io.grpc.stub.StreamObserver;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.hugegraph.pd.common.PDException;
import org.apache.hugegraph.pd.common.PDRuntimeException;
import org.apache.hugegraph.pd.grpc.Metapb;
import org.apache.hugegraph.pd.grpc.Pdpb;
import org.apache.hugegraph.pd.grpc.discovery.NodeInfo;
import org.apache.hugegraph.pd.grpc.discovery.Query;
import org.apache.hugegraph.pd.model.RegistryQueryRestRequest;
import org.apache.hugegraph.pd.model.RegistryRestRequest;
import org.apache.hugegraph.pd.model.RegistryRestResponse;
import org.apache.hugegraph.pd.rest.API;
import org.apache.hugegraph.pd.rest.MemberAPI;
import org.apache.hugegraph.pd.service.PDRestService;
import org.apache.hugegraph.pd.service.PDService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1"})
public class RegistryAPI
extends API {
    private static final Logger log = LoggerFactory.getLogger(RegistryAPI.class);
    @Autowired
    PDRestService pdRestService;
    @Autowired
    PDService pdService;

    @PostMapping(value={"/registry"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseBody
    public RegistryRestResponse register(@RequestBody RegistryRestRequest body, HttpServletRequest request) {
        RegistryRestResponse registryResponse = null;
        try {
            long interval = Long.valueOf(body.getInterval());
            NodeInfo info = NodeInfo.newBuilder().setAppName(body.getAppName()).setVersion(body.getVersion()).setAddress(body.getAddress()).putAllLabels((Map)body.getLabels()).setInterval(interval).build();
            registryResponse = this.pdRestService.register(info);
        }
        catch (PDException e) {
            registryResponse = new RegistryRestResponse();
            registryResponse.setErrorType(Pdpb.ErrorType.UNRECOGNIZED);
            registryResponse.setMessage(e.getMessage());
        }
        catch (PDRuntimeException e) {
            registryResponse = new RegistryRestResponse();
            registryResponse.setErrorType(Pdpb.ErrorType.LICENSE_VERIFY_ERROR);
            registryResponse.setMessage(e.getMessage());
        }
        return registryResponse;
    }

    @PostMapping(value={"/registryInfo"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseBody
    public RegistryRestResponse getInfo(@RequestBody RegistryQueryRestRequest body, HttpServletRequest request) {
        RegistryRestResponse response = new RegistryRestResponse();
        try {
            boolean labelNotEmpty = body.getLabels() != null && !body.getLabels().isEmpty();
            Query query = Query.newBuilder().setAppName(StringUtils.isEmpty((CharSequence)body.getAppName()) ? "" : body.getAppName()).putAllLabels((Map)(labelNotEmpty ? body.getLabels() : new HashMap())).setVersion(StringUtils.isEmpty((CharSequence)body.getVersion()) ? "" : body.getVersion()).build();
            ArrayList registryResponse = this.pdRestService.getNodeInfo(query);
            response.setErrorType(Pdpb.ErrorType.OK);
            response.setData((Serializable)registryResponse);
        }
        catch (Exception e) {
            log.warn(e.getMessage());
            response.setErrorType(Pdpb.ErrorType.UNRECOGNIZED);
            response.setMessage(e.getMessage());
        }
        return response;
    }

    @GetMapping(value={"/allInfo"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseBody
    public RegistryRestResponse allInfo(HttpServletRequest request) {
        RegistryRestResponse response = new RegistryRestResponse();
        try {
            Query query = Query.newBuilder().setAppName("").putAllLabels(new HashMap()).setVersion("").build();
            ArrayList registryResponse = this.pdRestService.getNodeInfo(query);
            LinkedList pdMembers = this.getMembers();
            List stores = this.pdRestService.getStores("");
            LinkedList<RegistryRestRequest> storeMembers = new LinkedList<RegistryRestRequest>();
            for (Metapb.Store store : stores) {
                RegistryRestRequest restRequest = new RegistryRestRequest();
                restRequest.setAddress(store.getAddress());
                restRequest.setVersion(store.getVersion());
                restRequest.setAppName("STORE");
                restRequest.setId(String.valueOf(store.getId()));
                storeMembers.add(restRequest);
            }
            response.setErrorType(Pdpb.ErrorType.OK);
            HashMap<String, AbstractList> result = new HashMap<String, AbstractList>();
            result.put("other", registryResponse);
            result.put("PD", pdMembers);
            result.put("STORE", storeMembers);
            response.setData(result);
        }
        catch (Exception e) {
            log.warn(e.getMessage());
            response.setErrorType(Pdpb.ErrorType.UNRECOGNIZED);
            response.setMessage(e.getMessage());
        }
        return response;
    }

    private LinkedList<RegistryRestRequest> getMembers() throws Exception {
        MemberAPI.CallStreamObserverWrap response = new MemberAPI.CallStreamObserverWrap();
        this.pdService.getMembers(Pdpb.GetMembersRequest.newBuilder().build(), (StreamObserver)response);
        LinkedList<RegistryRestRequest> members = new LinkedList<RegistryRestRequest>();
        List membersList = ((Pdpb.GetMembersResponse)response.get().get(0)).getMembersList();
        for (Metapb.Member member : membersList) {
            RegistryRestRequest restRequest = new RegistryRestRequest();
            restRequest.setAddress(member.getRestUrl());
            restRequest.setVersion("1.5.0");
            restRequest.setAppName("PD");
            members.add(restRequest);
        }
        return members;
    }

    @GetMapping(value={"/license"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseBody
    public RegistryRestResponse getLicenseInfo(HttpServletRequest request) {
        RegistryRestResponse response = new RegistryRestResponse();
        try {
            response.setErrorType(Pdpb.ErrorType.OK);
        }
        catch (Exception e) {
            log.warn(e.getMessage());
            response.setErrorType(Pdpb.ErrorType.UNRECOGNIZED);
            response.setMessage(e.getMessage());
        }
        return response;
    }

    @GetMapping(value={"/license/machineInfo"}, consumes={"application/json"}, produces={"application/json"})
    @ResponseBody
    public RegistryRestResponse getLicenseMachineInfo(HttpServletRequest request) {
        RegistryRestResponse response = new RegistryRestResponse();
        try {
            response.setErrorType(Pdpb.ErrorType.OK);
        }
        catch (Exception e) {
            log.warn(e.getMessage());
            response.setErrorType(Pdpb.ErrorType.UNRECOGNIZED);
            response.setMessage(e.getMessage());
        }
        return response;
    }
}

