/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.util;

import java.util.HashMap;
import java.util.Map;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.step.TraversalParent;

public final class TraversalMatrix<S, E> {
    private final Map<String, Step<?, ?>> matrix = new HashMap();
    private final Traversal.Admin<S, E> traversal;

    public TraversalMatrix(Traversal.Admin<S, E> traversal) {
        this.traversal = traversal;
        this.harvestSteps(this.traversal);
    }

    public <A, B, C extends Step<A, B>> C getStepById(String stepId) {
        return (C)this.matrix.get(stepId);
    }

    public Traversal.Admin<S, E> getTraversal() {
        return this.traversal;
    }

    private final void harvestSteps(Traversal.Admin<?, ?> traversal) {
        for (Step step : traversal.getSteps()) {
            this.matrix.put(step.getId(), step);
            if (!(step instanceof TraversalParent)) continue;
            for (Traversal.Admin globalChild : ((TraversalParent)((Object)step)).getGlobalChildren()) {
                this.harvestSteps(globalChild);
            }
            for (Traversal.Admin localChild : ((TraversalParent)((Object)step)).getLocalChildren()) {
                this.harvestSteps(localChild);
            }
        }
    }
}

