/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.io.Serializable;
import java.util.List;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.hadoop.hive.ql.plan.DDLDesc;
import org.apache.hadoop.hive.ql.plan.Explain;
import org.apache.hadoop.hive.ql.plan.PrincipalDesc;
import org.apache.hadoop.hive.ql.plan.PrivilegeDesc;
import org.apache.hadoop.hive.ql.plan.PrivilegeObjectDesc;

@Explain(displayName="Grant", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
public class GrantDesc
extends DDLDesc
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private List<PrivilegeDesc> privileges;
    private List<PrincipalDesc> principals;
    private boolean grantOption;
    private String grantor;
    private PrincipalType grantorType;
    private PrivilegeObjectDesc privilegeSubjectDesc;

    public GrantDesc(PrivilegeObjectDesc privilegeSubject, List<PrivilegeDesc> privilegeDesc, List<PrincipalDesc> principalDesc, String grantor, PrincipalType grantorType, boolean grantOption) {
        this.privilegeSubjectDesc = privilegeSubject;
        this.privileges = privilegeDesc;
        this.principals = principalDesc;
        this.grantor = grantor;
        this.grantorType = grantorType;
        this.grantOption = grantOption;
    }

    @Explain(displayName="Privileges", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public List<PrivilegeDesc> getPrivileges() {
        return this.privileges;
    }

    public void setPrivileges(List<PrivilegeDesc> privileges) {
        this.privileges = privileges;
    }

    @Explain(displayName="Principals", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public List<PrincipalDesc> getPrincipals() {
        return this.principals;
    }

    public void setPrincipals(List<PrincipalDesc> principals) {
        this.principals = principals;
    }

    @Explain(displayName="grant option", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public boolean isGrantOption() {
        return this.grantOption;
    }

    public void setGrantOption(boolean grantOption) {
        this.grantOption = grantOption;
    }

    @Explain(displayName="privilege subject", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public PrivilegeObjectDesc getPrivilegeSubjectDesc() {
        return this.privilegeSubjectDesc;
    }

    public void setPrivilegeSubjectDesc(PrivilegeObjectDesc privilegeSubjectDesc) {
        this.privilegeSubjectDesc = privilegeSubjectDesc;
    }

    public String getGrantor() {
        return this.grantor;
    }

    public void setGrantor(String grantor) {
        this.grantor = grantor;
    }

    public PrincipalType getGrantorType() {
        return this.grantorType;
    }

    public void setGrantorType(PrincipalType grantorType) {
        this.grantorType = grantorType;
    }
}

