/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.pd.client;

import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.MethodDescriptor;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.AbstractBlockingStub;
import io.grpc.stub.AbstractStub;
import io.grpc.stub.ClientCalls;
import io.grpc.stub.StreamObserver;
import java.io.Closeable;
import java.util.LinkedList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.hugegraph.pd.client.AbstractClientStubProxy;
import org.apache.hugegraph.pd.client.PDConfig;
import org.apache.hugegraph.pd.client.interceptor.Authentication;
import org.apache.hugegraph.pd.common.KVPair;
import org.apache.hugegraph.pd.common.PDException;
import org.apache.hugegraph.pd.grpc.Metapb;
import org.apache.hugegraph.pd.grpc.PDGrpc;
import org.apache.hugegraph.pd.grpc.Pdpb;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractClient
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(AbstractClient.class);
    private static ConcurrentHashMap<String, ManagedChannel> chs = new ConcurrentHashMap();
    public static Pdpb.ResponseHeader okHeader = Pdpb.ResponseHeader.newBuilder().setError(Pdpb.Error.newBuilder().setType(Pdpb.ErrorType.OK)).build();
    protected final Pdpb.RequestHeader header;
    protected final AbstractClientStubProxy proxy;
    protected final PDConfig config;
    protected ManagedChannel channel = null;
    protected ConcurrentMap<String, AbstractBlockingStub> stubs = null;

    protected AbstractClient(PDConfig config) {
        String[] hosts = config.getServerHost().split(",");
        this.proxy = new AbstractClientStubProxy(hosts);
        this.header = Pdpb.RequestHeader.getDefaultInstance();
        this.config = config;
    }

    public static Pdpb.ResponseHeader newErrorHeader(int errorCode, String errorMsg) {
        Pdpb.ResponseHeader header = Pdpb.ResponseHeader.newBuilder().setError(Pdpb.Error.newBuilder().setTypeValue(errorCode).setMessage(errorMsg)).build();
        return header;
    }

    protected static void handleErrors(Pdpb.ResponseHeader header) throws PDException {
        Pdpb.Error error = header.getError();
        if (header.hasError() && error.getType() != Pdpb.ErrorType.OK) {
            throw new PDException(error.getTypeValue(), String.format("PD request error, error code = %d, msg = %s", error.getTypeValue(), error.getMessage()));
        }
    }

    public static <T extends AbstractStub> T setBlockingParams(T stub, PDConfig config) {
        stub = stub.withDeadlineAfter(config.getGrpcTimeOut(), TimeUnit.MILLISECONDS).withMaxInboundMessageSize(PDConfig.getInboundMessageSize());
        return (T)stub.withInterceptors(new ClientInterceptor[]{new Authentication(config.getUserName(), config.getAuthority())});
    }

    public static <T extends AbstractStub> T setAsyncParams(T stub, PDConfig config) {
        return (T)stub.withMaxInboundMessageSize(PDConfig.getInboundMessageSize()).withInterceptors(new ClientInterceptor[]{new Authentication(config.getUserName(), config.getAuthority())});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AbstractBlockingStub getBlockingStub() throws PDException {
        if (this.proxy.getBlockingStub() == null) {
            AbstractClient abstractClient = this;
            synchronized (abstractClient) {
                String host;
                if (this.proxy.getBlockingStub() == null && (host = this.resetStub()).isEmpty()) {
                    throw new PDException(104, "PD unreachable, pd.peers=" + this.config.getServerHost());
                }
            }
        }
        return AbstractClient.setBlockingParams(this.proxy.getBlockingStub(), this.config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AbstractStub getStub() throws PDException {
        if (this.proxy.getStub() == null) {
            AbstractClient abstractClient = this;
            synchronized (abstractClient) {
                String host;
                if (this.proxy.getStub() == null && (host = this.resetStub()).isEmpty()) {
                    throw new PDException(104, "PD unreachable, pd.peers=" + this.config.getServerHost());
                }
            }
        }
        return AbstractClient.setAsyncParams(this.proxy.getStub(), this.config);
    }

    protected abstract AbstractStub createStub();

    protected abstract AbstractBlockingStub createBlockingStub();

    private String resetStub() {
        String leaderHost = "";
        Throwable ex = null;
        for (int i = 0; i < this.proxy.getHostCount(); ++i) {
            String host = this.proxy.nextHost();
            this.close();
            this.channel = ManagedChannelBuilder.forTarget((String)host).usePlaintext().build();
            PDGrpc.PDBlockingStub blockingStub = AbstractClient.setBlockingParams(PDGrpc.newBlockingStub((Channel)this.channel), this.config);
            try {
                Pdpb.GetMembersRequest request = Pdpb.GetMembersRequest.newBuilder().setHeader(this.header).build();
                Pdpb.GetMembersResponse members = blockingStub.getMembers(request);
                Metapb.Member leader = members.getLeader();
                leaderHost = leader.getGrpcUrl();
                if (!host.equals(leaderHost)) {
                    this.close();
                    this.channel = ManagedChannelBuilder.forTarget((String)leaderHost).usePlaintext().build();
                }
                this.proxy.setBlockingStub(AbstractClient.setBlockingParams(this.createBlockingStub(), this.config));
                this.proxy.setStub(AbstractClient.setAsyncParams(this.createStub(), this.config));
                log.info("AbstractClient connect to host = {} success", (Object)leaderHost);
                break;
            }
            catch (StatusRuntimeException se) {
                ex = se;
                continue;
            }
            catch (Exception e) {
                ex = e;
                String msg = String.format("AbstractClient connect to %s with error: %s", host, e.getMessage());
                log.error(msg, (Throwable)e);
            }
        }
        if (StringUtils.isEmpty((CharSequence)leaderHost) && ex != null) {
            log.error(String.format("connect to %s with error: ", this.config.getServerHost()), ex);
        }
        return leaderHost;
    }

    protected <ReqT, RespT> RespT blockingUnaryCall(MethodDescriptor<ReqT, RespT> method, ReqT req) throws PDException {
        return this.blockingUnaryCall(method, req, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <ReqT, RespT> RespT blockingUnaryCall(MethodDescriptor<ReqT, RespT> method, ReqT req, int retry) throws PDException {
        AbstractBlockingStub stub = this.getBlockingStub();
        try {
            Object resp = ClientCalls.blockingUnaryCall((Channel)stub.getChannel(), method, (CallOptions)stub.getCallOptions(), req);
            return (RespT)resp;
        }
        catch (Exception e) {
            if (e instanceof StatusRuntimeException) {
                if (retry < this.proxy.getHostCount()) {
                    AbstractClient abstractClient = this;
                    synchronized (abstractClient) {
                        this.proxy.setBlockingStub(null);
                    }
                    return this.blockingUnaryCall(method, req, ++retry);
                }
            } else {
                log.error(method.getFullMethodName() + " exception, ", (Throwable)e);
            }
            return null;
        }
    }

    private AbstractBlockingStub getConcurrentBlockingStub(String address) {
        AbstractBlockingStub stub = (AbstractBlockingStub)this.stubs.get(address);
        if (stub != null) {
            return stub;
        }
        ManagedChannel ch = ManagedChannelBuilder.forTarget((String)address).usePlaintext().build();
        PDGrpc.PDBlockingStub blockingStub = AbstractClient.setBlockingParams(PDGrpc.newBlockingStub((Channel)ch), this.config);
        this.stubs.put(address, (AbstractBlockingStub)blockingStub);
        return blockingStub;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <ReqT, RespT> KVPair<Boolean, RespT> concurrentBlockingUnaryCall(MethodDescriptor<ReqT, RespT> method, ReqT req, Predicate<RespT> predicate) throws PDException {
        AtomicReference response;
        Stream<Object> respTStream;
        boolean result;
        LinkedList<String> hostList = this.proxy.getHostList();
        if (this.stubs == null) {
            AbstractClient abstractClient = this;
            synchronized (abstractClient) {
                if (this.stubs == null) {
                    this.stubs = new ConcurrentHashMap<String, AbstractBlockingStub>(hostList.size());
                }
            }
        }
        KVPair pair = (result = (respTStream = hostList.parallelStream().map(address -> {
            AbstractBlockingStub stub = this.getConcurrentBlockingStub((String)address);
            Object resp = ClientCalls.blockingUnaryCall((Channel)stub.getChannel(), (MethodDescriptor)method, (CallOptions)stub.getCallOptions(), (Object)req);
            return resp;
        })).anyMatch(arg_0 -> AbstractClient.lambda$concurrentBlockingUnaryCall$1(response = new AtomicReference(), predicate, arg_0))) ? new KVPair((Object)true, null) : new KVPair((Object)false, response.get());
        return pair;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <ReqT, RespT> void streamingCall(MethodDescriptor<ReqT, RespT> method, ReqT request, StreamObserver<RespT> responseObserver, int retry) throws PDException {
        block5: {
            AbstractStub stub = this.getStub();
            try {
                ClientCall call = stub.getChannel().newCall(method, stub.getCallOptions());
                ClientCalls.asyncServerStreamingCall((ClientCall)call, request, responseObserver);
            }
            catch (Exception e) {
                log.error("rpc call with exception :", (Throwable)e);
                if (!(e instanceof StatusRuntimeException) || retry >= this.proxy.getHostCount()) break block5;
                AbstractClient abstractClient = this;
                synchronized (abstractClient) {
                    this.proxy.setStub(null);
                }
                this.streamingCall(method, request, responseObserver, ++retry);
            }
        }
    }

    @Override
    public void close() {
        this.closeChannel(this.channel);
        if (this.stubs != null) {
            for (AbstractBlockingStub stub : this.stubs.values()) {
                this.closeChannel((ManagedChannel)stub.getChannel());
            }
        }
    }

    private void closeChannel(ManagedChannel channel) {
        try {
            while (channel != null && !channel.shutdownNow().awaitTermination(100L, TimeUnit.MILLISECONDS)) {
            }
        }
        catch (Exception e) {
            log.info("Close channel with error :.", (Throwable)e);
        }
    }

    private static /* synthetic */ boolean lambda$concurrentBlockingUnaryCall$1(AtomicReference response, Predicate predicate, Object r) {
        response.set(r);
        return predicate.test(r);
    }
}

