/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fury.collection;

import java.util.Arrays;

public class IntArray {
    public int[] elementData;
    public int size;

    public IntArray(int capacity) {
        this.elementData = new int[capacity];
    }

    public void add(int value) {
        int[] items = this.elementData;
        if (this.size == items.length) {
            int newSize = this.size * 2;
            int[] newItems = new int[newSize];
            System.arraycopy(items, 0, newItems, 0, items.length);
            this.elementData = newItems;
            items = newItems;
        }
        items[this.size++] = value;
    }

    public int get(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException(String.valueOf(index));
        }
        return this.elementData[index];
    }

    public int pop() {
        return this.elementData[--this.size];
    }

    public void clear() {
        this.size = 0;
    }

    public String toString() {
        return Arrays.toString(Arrays.copyOfRange(this.elementData, 0, this.size));
    }
}

