/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.pd.model;

import java.util.ArrayList;
import java.util.List;
import org.apache.hugegraph.pd.common.PDException;
import org.apache.hugegraph.pd.grpc.Metapb;
import org.apache.hugegraph.pd.model.Shard;
import org.apache.hugegraph.pd.service.PDService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Partition {
    private static final Logger log = LoggerFactory.getLogger(Partition.class);
    int partitionId;
    String graphName;
    String workState;
    long startKey;
    long endKey;
    List<Shard> shards;
    long dataSize;
    private transient PDService pdService;

    public Partition(Metapb.Partition pt, Metapb.PartitionStats stats, PDService service) {
        this.pdService = service;
        if (pt != null) {
            this.partitionId = pt.getId();
            this.startKey = pt.getStartKey();
            this.endKey = pt.getEndKey();
            this.workState = String.valueOf(pt.getState());
            this.graphName = pt.getGraphName();
            int postfixLength = 2;
            if (this.graphName != null && this.graphName.length() > 2) {
                this.graphName = this.graphName.substring(0, this.graphName.length() - 2);
            } else {
                log.error("Partition graphName '{}' too short to trim postfixLength={}", (Object)this.graphName, (Object)2);
            }
            this.graphName = this.graphName.substring(0, this.graphName.length() - 2);
            if (stats != null) {
                List shardStatsList = stats.getShardStatsList();
                ArrayList<Shard> shardsList = new ArrayList<Shard>();
                for (Metapb.ShardStats shardStats : shardStatsList) {
                    Shard shard = new Shard(shardStats, (long)this.partitionId);
                    shardsList.add(shard);
                }
                this.shards = shardsList;
            } else {
                ArrayList<Shard> shardsList = new ArrayList<Shard>();
                try {
                    Metapb.ShardGroup shardGroup = this.pdService.getStoreNodeService().getShardGroup(pt.getId());
                    if (shardGroup != null) {
                        for (Metapb.Shard shard1 : shardGroup.getShardsList()) {
                            shardsList.add(new Shard(shard1, (long)this.partitionId));
                        }
                    } else {
                        log.error("GraphAPI.Partition(), get shard group: {} returns null", (Object)pt.getId());
                    }
                }
                catch (PDException e) {
                    log.error("Partition init failed, error: {}", (Object)e.getMessage());
                }
                this.shards = shardsList;
            }
        }
    }

    public int getPartitionId() {
        return this.partitionId;
    }

    public String getGraphName() {
        return this.graphName;
    }

    public String getWorkState() {
        return this.workState;
    }

    public long getStartKey() {
        return this.startKey;
    }

    public long getEndKey() {
        return this.endKey;
    }

    public List<Shard> getShards() {
        return this.shards;
    }

    public long getDataSize() {
        return this.dataSize;
    }

    public void setPartitionId(int partitionId) {
        this.partitionId = partitionId;
    }

    public void setGraphName(String graphName) {
        this.graphName = graphName;
    }

    public void setWorkState(String workState) {
        this.workState = workState;
    }

    public void setStartKey(long startKey) {
        this.startKey = startKey;
    }

    public void setEndKey(long endKey) {
        this.endKey = endKey;
    }

    public void setShards(List<Shard> shards) {
        this.shards = shards;
    }

    public void setDataSize(long dataSize) {
        this.dataSize = dataSize;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Partition)) {
            return false;
        }
        Partition other = (Partition)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getPartitionId() != other.getPartitionId()) {
            return false;
        }
        if (this.getStartKey() != other.getStartKey()) {
            return false;
        }
        if (this.getEndKey() != other.getEndKey()) {
            return false;
        }
        if (this.getDataSize() != other.getDataSize()) {
            return false;
        }
        String this$graphName = this.getGraphName();
        String other$graphName = other.getGraphName();
        if (this$graphName == null ? other$graphName != null : !this$graphName.equals(other$graphName)) {
            return false;
        }
        String this$workState = this.getWorkState();
        String other$workState = other.getWorkState();
        if (this$workState == null ? other$workState != null : !this$workState.equals(other$workState)) {
            return false;
        }
        List this$shards = this.getShards();
        List other$shards = other.getShards();
        return !(this$shards == null ? other$shards != null : !((Object)this$shards).equals(other$shards));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Partition;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPartitionId();
        long $startKey = this.getStartKey();
        result = result * 59 + (int)($startKey >>> 32 ^ $startKey);
        long $endKey = this.getEndKey();
        result = result * 59 + (int)($endKey >>> 32 ^ $endKey);
        long $dataSize = this.getDataSize();
        result = result * 59 + (int)($dataSize >>> 32 ^ $dataSize);
        String $graphName = this.getGraphName();
        result = result * 59 + ($graphName == null ? 43 : $graphName.hashCode());
        String $workState = this.getWorkState();
        result = result * 59 + ($workState == null ? 43 : $workState.hashCode());
        List $shards = this.getShards();
        result = result * 59 + ($shards == null ? 43 : ((Object)$shards).hashCode());
        return result;
    }

    public String toString() {
        return "Partition(partitionId=" + this.getPartitionId() + ", graphName=" + this.getGraphName() + ", workState=" + this.getWorkState() + ", startKey=" + this.getStartKey() + ", endKey=" + this.getEndKey() + ", shards=" + String.valueOf(this.getShards()) + ", dataSize=" + this.getDataSize() + ", pdService=" + String.valueOf(this.pdService) + ")";
    }
}

