/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.api.traversers;

import com.codahale.metrics.annotation.Timed;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Singleton;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.hugegraph.HugeGraph;
import org.apache.hugegraph.api.API;
import org.apache.hugegraph.api.traversers.TraverserAPI;
import org.apache.hugegraph.api.traversers.Vertices;
import org.apache.hugegraph.core.GraphManager;
import org.apache.hugegraph.traversal.algorithm.HugeTraverser;
import org.apache.hugegraph.traversal.algorithm.MultiNodeShortestPathTraverser;
import org.apache.hugegraph.traversal.algorithm.steps.EdgeStep;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.Log;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.slf4j.Logger;

@Path(value="graphspaces/{graphspace}/graphs/{graph}/traversers/multinodeshortestpath")
@Singleton
@Tag(name="MultiNodeShortestPathAPI")
public class MultiNodeShortestPathAPI
extends TraverserAPI {
    private static final Logger LOG = Log.logger(MultiNodeShortestPathAPI.class);

    @POST
    @Timed
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;charset=UTF-8"})
    public String post(@Context GraphManager manager, @PathParam(value="graphspace") String graphSpace, @PathParam(value="graph") String graph, Request request) {
        Iterator iterVertex;
        MultiNodeShortestPathTraverser.WrappedListPath wrappedListPath;
        E.checkArgumentNotNull((Object)request, (String)"The request body can't be null", (Object[])new Object[0]);
        E.checkArgumentNotNull((Object)request.vertices, (String)"The vertices of request can't be null", (Object[])new Object[0]);
        E.checkArgument((request.step != null ? 1 : 0) != 0, (String)"The steps of request can't be null", (Object[])new Object[0]);
        LOG.debug("Graph [{}] get multiple node shortest path from vertices '{}', with step '{}', max_depth '{}', capacity '{}' and with_vertex '{}'", new Object[]{graph, request.vertices, request.step, request.maxDepth, request.capacity, request.withVertex});
        API.ApiMeasurer measure = new API.ApiMeasurer();
        HugeGraph g = MultiNodeShortestPathAPI.graph(manager, graphSpace, graph);
        Iterator<Vertex> vertices = request.vertices.vertices(g);
        EdgeStep step = MultiNodeShortestPathAPI.step(g, request.step);
        try (MultiNodeShortestPathTraverser traverser = new MultiNodeShortestPathTraverser(g);){
            wrappedListPath = traverser.multiNodeShortestPath(vertices, step, request.maxDepth, request.capacity);
            measure.addIterCount(traverser.vertexIterCounter.get(), traverser.edgeIterCounter.get());
        }
        List paths = wrappedListPath.paths();
        HashSet vertexIds = new HashSet();
        for (HugeTraverser.Path path : paths) {
            vertexIds.addAll(path.vertices());
        }
        if (request.withVertex && !vertexIds.isEmpty()) {
            iterVertex = g.vertices(vertexIds.toArray());
            measure.addIterCount(vertexIds.size(), 0L);
        } else {
            iterVertex = vertexIds.iterator();
        }
        Set edges = wrappedListPath.edges();
        Iterator iterEdge = request.withEdge && !edges.isEmpty() ? wrappedListPath.edges().iterator() : HugeTraverser.EdgeRecord.getEdgeIds((Set)edges).iterator();
        return manager.serializer((Graph)g, measure.measures()).writePaths("paths", paths, false, iterVertex, iterEdge);
    }

    private static class Request {
        @JsonProperty(value="vertices")
        public Vertices vertices;
        @JsonProperty(value="step")
        public TraverserAPI.Step step;
        @JsonProperty(value="max_depth")
        public int maxDepth;
        @JsonProperty(value="capacity")
        public long capacity = Long.parseLong("10000000");
        @JsonProperty(value="with_vertex")
        public boolean withVertex = false;
        @JsonProperty(value="with_edge")
        public boolean withEdge = false;

        private Request() {
        }

        public String toString() {
            return String.format("Request{vertices=%s,step=%s,maxDepth=%scapacity=%s,withVertex=%s,withEdge=%s}", this.vertices, this.step, this.maxDepth, this.capacity, this.withVertex, this.withEdge);
        }
    }
}

