/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.backend;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.hugegraph.id.Id;
import org.apache.hugegraph.util.Bytes;
import org.apache.hugegraph.util.E;

public final class BinaryId
implements Id {
    private final byte[] bytes;
    private final Id id;

    public BinaryId(byte[] bytes, Id id) {
        this.bytes = bytes;
        this.id = id;
    }

    public Id origin() {
        return this.id;
    }

    @Override
    public Id.IdType type() {
        return Id.IdType.UNKNOWN;
    }

    @Override
    public Object asObject() {
        return ByteBuffer.wrap(this.bytes);
    }

    @Override
    public String asString() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long asLong() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int compareTo(Id other) {
        return Bytes.compare((byte[])this.bytes, (byte[])other.asBytes());
    }

    @Override
    public byte[] asBytes() {
        return this.bytes;
    }

    public byte[] asBytes(int offset) {
        E.checkArgument((offset < this.bytes.length ? 1 : 0) != 0, (String)"Invalid offset %s, must be < length %s", (Object[])new Object[]{offset, this.bytes.length});
        return Arrays.copyOfRange(this.bytes, offset, this.bytes.length);
    }

    @Override
    public int length() {
        return this.bytes.length;
    }

    public int hashCode() {
        return ByteBuffer.wrap(this.bytes).hashCode();
    }

    public boolean equals(Object other) {
        if (!(other instanceof BinaryId)) {
            return false;
        }
        return Arrays.equals(this.bytes, ((BinaryId)other).bytes);
    }

    public String toString() {
        return "0x" + Bytes.toHex((byte[])this.bytes);
    }
}

