/*
 * Decompiled with CFR 0.152.
 */
package org.apdplat.word.corpus;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apdplat.word.WordSegmenter;
import org.apdplat.word.corpus.EvaluationResult;
import org.apdplat.word.corpus.ExtractText;
import org.apdplat.word.recognition.Punctuation;
import org.apdplat.word.segmentation.SegmentationAlgorithm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Evaluation {
    private static final Logger LOGGER = LoggerFactory.getLogger(Evaluation.class);

    public static void main(String[] stringArray) throws Exception {
        String string = "target/evaluation/corpus-text.txt";
        String string2 = "target/evaluation/test-text.txt";
        String string3 = "target/evaluation/standard-text.txt";
        String string4 = "target/evaluation/result-text-";
        String string5 = "target/evaluation/perfect-result-";
        String string6 = "target/evaluation/wrong-result-";
        Path path = Paths.get("target/evaluation", new String[0]);
        if (!Files.exists(path, new LinkOption[0])) {
            Files.createDirectory(path, new FileAttribute[0]);
        }
        ExtractText.extractFromCorpus(string, " ", false);
        int n = Evaluation.generateDataset(string, string2, string3);
        ArrayList<EvaluationResult> arrayList = new ArrayList<EvaluationResult>();
        for (SegmentationAlgorithm segmentationAlgorithm : SegmentationAlgorithm.values()) {
            long l = System.currentTimeMillis();
            WordSegmenter.segWithStopWords(new File(string2), new File(string4 + segmentationAlgorithm.name() + ".txt"), segmentationAlgorithm);
            long l2 = System.currentTimeMillis() - l;
            float f = (float)n / (float)l2;
            EvaluationResult evaluationResult = Evaluation.evaluation(string4 + segmentationAlgorithm.name() + ".txt", string3, string5 + segmentationAlgorithm.name() + ".txt", string6 + segmentationAlgorithm.name() + ".txt");
            evaluationResult.setSegmentationAlgorithm(segmentationAlgorithm);
            evaluationResult.setSegSpeed(f);
            arrayList.add(evaluationResult);
        }
        LOGGER.info("*************************************************************************************************************");
        Collections.sort(arrayList);
        for (int i = 0; i < arrayList.size(); ++i) {
            LOGGER.info(((EvaluationResult)arrayList.get(i)).toString());
            if (i >= arrayList.size() - 1) continue;
            LOGGER.info("");
        }
        LOGGER.info("*************************************************************************************************************");
    }

    public static int generateDataset(String string, String string2, String string3) {
        int n = 0;
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(string), "utf-8"));
             BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(string2), "utf-8"));
             BufferedWriter bufferedWriter2 = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(string3), "utf-8"));){
            String string4;
            int n2 = 0;
            HashSet<String> hashSet = new HashSet<String>();
            while ((string4 = bufferedReader.readLine()) != null) {
                List<String> list = Punctuation.seg(string4, false, ' ');
                for (String string5 : list) {
                    if ("".equals(string5 = string5.trim()) || string5.length() == 1) continue;
                    if (hashSet.contains(string5)) {
                        ++n2;
                        continue;
                    }
                    hashSet.add(string5);
                    String string6 = string5.replaceAll(" ", "");
                    n += string6.length();
                    bufferedWriter.write(string6 + "\n");
                    bufferedWriter2.write(string5 + "\n");
                }
            }
            LOGGER.info("\u91cd\u590d\u884c\u6570\u4e3a\uff1a" + n2);
        }
        catch (IOException iOException) {
            LOGGER.error("\u751f\u6210\u6d4b\u8bd5\u6570\u636e\u96c6\u548c\u6807\u51c6\u6570\u636e\u96c6\u5931\u8d25\uff1a", (Throwable)iOException);
        }
        return n;
    }

    public static EvaluationResult evaluation(String string, String string2, String string3, String string4) {
        Object object;
        long l = System.currentTimeMillis();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(string), "utf-8"));
             BufferedReader bufferedReader2 = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(string2), "utf-8"));){
            object = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(string3), "utf-8"));
            Throwable throwable = null;
            try (BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(string4), "utf-8"));){
                String string5;
                while ((string5 = bufferedReader.readLine()) != null) {
                    string5 = string5.trim();
                    String string6 = bufferedReader2.readLine().trim();
                    if (string5.equals("")) continue;
                    if (string5.equals(string6)) {
                        ((Writer)object).write(string6 + "\n");
                        ++n;
                        n3 += string6.replaceAll("\\s+", "").length();
                        continue;
                    }
                    bufferedWriter.write("\u5b9e\u9645\u5206\u8bcd\u7ed3\u679c\uff1a" + string5 + "\n");
                    bufferedWriter.write("\u6807\u51c6\u5206\u8bcd\u7ed3\u679c\uff1a" + string6 + "\n");
                    ++n2;
                    n4 += string6.replaceAll("\\s+", "").length();
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (object != null) {
                    if (throwable != null) {
                        try {
                            ((BufferedWriter)object).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        ((BufferedWriter)object).close();
                    }
                }
            }
        }
        catch (IOException iOException) {
            LOGGER.error("\u5206\u8bcd\u6548\u679c\u8bc4\u4f30\u5931\u8d25\uff1a", (Throwable)iOException);
        }
        long l2 = System.currentTimeMillis() - l;
        int n5 = n + n2;
        int n6 = n3 + n4;
        LOGGER.info("\u8bc4\u4f30\u8017\u65f6\uff1a" + l2 + " \u6beb\u79d2");
        object = new EvaluationResult();
        ((EvaluationResult)object).setPerfectCharCount(n3);
        ((EvaluationResult)object).setPerfectLineCount(n);
        ((EvaluationResult)object).setTotalCharCount(n6);
        ((EvaluationResult)object).setTotalLineCount(n5);
        ((EvaluationResult)object).setWrongCharCount(n4);
        ((EvaluationResult)object).setWrongLineCount(n2);
        return object;
    }

    public static EvaluationResult evaluation(String string, String string2) {
        Object object;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(string), "utf-8"));){
            object = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(string2), "utf-8"));
            Throwable throwable = null;
            try {
                String string3;
                while ((string3 = bufferedReader.readLine()) != null) {
                    string3 = string3.trim();
                    String string4 = ((BufferedReader)object).readLine().trim();
                    if (string3.equals("")) continue;
                    if (string3.equals(string4)) {
                        ++n;
                        n3 += string4.replaceAll("\\s+", "").length();
                        continue;
                    }
                    ++n2;
                    n4 += string4.replaceAll("\\s+", "").length();
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (object != null) {
                    if (throwable != null) {
                        try {
                            ((BufferedReader)object).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        ((BufferedReader)object).close();
                    }
                }
            }
        }
        catch (IOException iOException) {
            LOGGER.error("\u5206\u8bcd\u6548\u679c\u8bc4\u4f30\u5931\u8d25\uff1a", (Throwable)iOException);
        }
        int n5 = n + n2;
        int n6 = n3 + n4;
        object = new EvaluationResult();
        ((EvaluationResult)object).setPerfectCharCount(n3);
        ((EvaluationResult)object).setPerfectLineCount(n);
        ((EvaluationResult)object).setTotalCharCount(n6);
        ((EvaluationResult)object).setTotalLineCount(n5);
        ((EvaluationResult)object).setWrongCharCount(n4);
        ((EvaluationResult)object).setWrongLineCount(n2);
        return object;
    }
}

