/*
 * Decompiled with CFR 0.152.
 */
package org.apdplat.word.dictionary;

import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apdplat.word.dictionary.Dictionary;
import org.apdplat.word.dictionary.impl.DictionaryTrie;
import org.apdplat.word.recognition.PersonName;
import org.apdplat.word.util.AutoDetector;
import org.apdplat.word.util.ResourceLoader;
import org.apdplat.word.util.WordConfTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DictionaryFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(DictionaryFactory.class);
    private static final int INTERCEPT_LENGTH = WordConfTools.getInt("intercept.length", 16);

    private DictionaryFactory() {
    }

    public static final Dictionary getDictionary() {
        return DictionaryHolder.DIC;
    }

    public static void reload() {
        DictionaryHolder.reload();
    }

    private static void test(String string2) throws Exception {
        WordConfTools.set("dic.class", string2);
        System.gc();
        Thread.sleep(60000L);
        Dictionary dictionary = DictionaryFactory.getDictionary();
        System.gc();
        Thread.sleep(60000L);
        AtomicInteger atomicInteger = new AtomicInteger();
        AtomicInteger atomicInteger2 = new AtomicInteger();
        Stream<String> stream = Files.lines(Paths.get("src/test/resources/dic.txt", new String[0]));
        System.gc();
        Thread.sleep(60000L);
        long l = System.currentTimeMillis();
        for (int i = 0; i < 100; ++i) {
            stream.forEach(string -> {
                for (int i = 0; i < string.length(); ++i) {
                    String string2 = string.substring(0, i + 1);
                    for (int j = 0; j < string2.length(); ++j) {
                        if (dictionary.contains(string2, j, string2.length() - j)) {
                            atomicInteger.incrementAndGet();
                            continue;
                        }
                        atomicInteger2.incrementAndGet();
                    }
                }
            });
        }
        long l2 = System.currentTimeMillis() - l;
        LOGGER.info(string2 + " \u672a\u67e5\u8be2\u5230\u7684\u6b21\u6570\uff1a" + atomicInteger2.get() + "\uff0c \u67e5\u8be2\u5230\u7684\u6b21\u6570\uff1a" + atomicInteger.get() + " \u8017\u65f6\uff1a" + l2 + " \u6beb\u79d2");
        System.gc();
        Thread.sleep(60000L);
        LOGGER.info("test finish");
        System.exit(0);
    }

    public static void main(String[] stringArray) throws Exception {
        DictionaryFactory.test("org.apdplat.word.dictionary.impl.DoubleArrayDictionaryTrie");
    }

    private static final class DictionaryHolder {
        private static final Dictionary DIC = DictionaryHolder.constructDictionary();

        private DictionaryHolder() {
        }

        private static Dictionary constructDictionary() {
            try {
                String string = WordConfTools.get("dic.class", "org.apdplat.word.dictionary.impl.TrieV4");
                LOGGER.info("dic.class=" + string);
                return (Dictionary)Class.forName(string.trim()).newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException reflectiveOperationException) {
                System.err.println("\u8bcd\u5178\u88c5\u8f7d\u5931\u8d25:" + reflectiveOperationException.getMessage());
                throw new RuntimeException(reflectiveOperationException);
            }
        }

        public static void reload() {
            AutoDetector.loadAndWatch(new ResourceLoader(){

                @Override
                public void clear() {
                    DIC.clear();
                }

                @Override
                public void load(List<String> list) {
                    String string2;
                    LOGGER.info("\u521d\u59cb\u5316\u8bcd\u5178");
                    long l = System.currentTimeMillis();
                    int n = 0;
                    for (String string2 : PersonName.getSurnames()) {
                        if (string2.length() != 2) continue;
                        ++n;
                        list.add(string2);
                    }
                    LOGGER.info("\u5c06 " + n + " \u4e2a\u590d\u59d3\u52a0\u5165\u8bcd\u5178");
                    List<String> list2 = this.getAllWords(list);
                    list.clear();
                    string2 = WordConfTools.get("dic.dump.path");
                    if (string2 != null && string2.length() > 0) {
                        try {
                            Files.write(Paths.get(string2, new String[0]), (Iterable<? extends CharSequence>)list2, new OpenOption[0]);
                        }
                        catch (Exception exception) {
                            LOGGER.error("dic dump error!", (Throwable)exception);
                        }
                    }
                    DIC.addAll(list2);
                    this.showStatistics(list2);
                    if (DIC instanceof DictionaryTrie) {
                        DictionaryTrie dictionaryTrie = (DictionaryTrie)DIC;
                        dictionaryTrie.showConflict();
                    }
                    System.gc();
                    LOGGER.info("\u8bcd\u5178\u521d\u59cb\u5316\u5b8c\u6bd5\uff0c\u8017\u65f6\uff1a" + (System.currentTimeMillis() - l) + " \u6beb\u79d2");
                }

                private void showStatistics(List<String> list) {
                    int n;
                    HashMap hashMap = new HashMap();
                    list.forEach(string -> {
                        hashMap.putIfAbsent(string.length(), new AtomicInteger());
                        ((AtomicInteger)hashMap.get(string.length())).incrementAndGet();
                    });
                    int n2 = 0;
                    int n3 = 0;
                    Iterator iterator = hashMap.keySet().iterator();
                    while (iterator.hasNext()) {
                        n = (Integer)iterator.next();
                        n3 += n * ((AtomicInteger)hashMap.get(n)).get();
                        n2 += ((AtomicInteger)hashMap.get(n)).get();
                    }
                    LOGGER.info("\u8bcd\u6570\u76ee\uff1a" + n2 + "\uff0c\u8bcd\u5178\u6700\u5927\u8bcd\u957f\uff1a" + DIC.getMaxLength());
                    iterator = hashMap.keySet().iterator();
                    while (iterator.hasNext()) {
                        n = (Integer)iterator.next();
                        if (n < 10) {
                            LOGGER.info("\u8bcd\u957f  " + n + " \u7684\u8bcd\u6570\u4e3a\uff1a" + hashMap.get(n));
                            continue;
                        }
                        LOGGER.info("\u8bcd\u957f " + n + " \u7684\u8bcd\u6570\u4e3a\uff1a" + hashMap.get(n));
                    }
                    LOGGER.info("\u8bcd\u5178\u5e73\u5747\u8bcd\u957f\uff1a" + (float)n3 / (float)n2);
                }

                @Override
                public void add(String string2) {
                    this.getWords(string2).stream().filter(string -> string.length() <= INTERCEPT_LENGTH).forEach(DIC::add);
                }

                @Override
                public void remove(String string) {
                    this.getWords(string).forEach(DIC::remove);
                }

                private List<String> getAllWords(List<String> list) {
                    return list.stream().flatMap(string -> this.getWords((String)string).stream()).filter(string -> string.length() <= INTERCEPT_LENGTH).collect(Collectors.toSet()).stream().sorted().collect(Collectors.toList());
                }

                private List<String> getWords(String string) {
                    ArrayList<String> arrayList = new ArrayList<String>();
                    for (String string2 : string.split("\\s+")) {
                        String[] stringArray;
                        if (string2.length() > 2 && string2.contains(":") && (stringArray = string2.split(":")) != null && stringArray.length > 1) {
                            string2 = stringArray[0].length() > 1 ? stringArray[0] : null;
                        }
                        if (string2 == null) continue;
                        arrayList.add(string2);
                    }
                    return arrayList;
                }
            }, WordConfTools.get("dic.path", "classpath:dic.txt") + "," + WordConfTools.get("punctuation.path", "classpath:punctuation.txt") + "," + WordConfTools.get("part.of.speech.dic.path", "classpath:part_of_speech_dic.txt") + "," + WordConfTools.get("word.synonym.path", "classpath:word_synonym.txt") + "," + WordConfTools.get("word.antonym.path", "classpath:word_antonym.txt"));
        }

        static {
            DictionaryHolder.reload();
        }
    }
}

