/*
 * Decompiled with CFR 0.152.
 */
package org.apdplat.word.dictionary;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apdplat.word.recognition.RecognitionTool;
import org.apdplat.word.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DictionaryTools {
    private static final Logger LOGGER = LoggerFactory.getLogger(DictionaryTools.class);

    public static void main(String[] stringArray) throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("src/main/resources/dic.txt");
        arrayList.add("target/dic.txt");
        String string = "src/main/resources/dic.txt";
        DictionaryTools.merge(arrayList, string);
    }

    public static void removePhraseFromDic(String string2, String string3) {
        try (Stream<String> stream = Files.lines(Paths.get(string2, new String[0]), Charset.forName("utf-8"));
             Stream<String> stream2 = Files.lines(Paths.get(string3, new String[0]), Charset.forName("utf-8"));){
            HashSet hashSet = new HashSet();
            stream.forEach(string -> {
                String[] stringArray = string.split("=");
                if (stringArray != null && stringArray.length == 2) {
                    hashSet.add(stringArray[0]);
                }
            });
            ArrayList arrayList = new ArrayList();
            AtomicInteger atomicInteger = new AtomicInteger();
            stream2.forEach(string -> {
                atomicInteger.incrementAndGet();
                if (!hashSet.contains(string)) {
                    arrayList.add(string);
                }
            });
            hashSet.clear();
            Files.write(Paths.get(string3, new String[0]), arrayList, Charset.forName("utf-8"), new OpenOption[0]);
            LOGGER.info("\u79fb\u9664\u77ed\u8bed\u7ed3\u6784\u6570\u76ee\uff1a" + (atomicInteger.get() - arrayList.size()));
        }
        catch (Exception exception) {
            LOGGER.error("\u79fb\u9664\u77ed\u8bed\u7ed3\u6784\u5931\u8d25\uff1a", (Throwable)exception);
        }
    }

    public static void merge(List<String> list, String string2) throws IOException {
        HashSet hashSet = new HashSet();
        AtomicInteger atomicInteger = new AtomicInteger();
        for (String string3 : list) {
            Stream<String> stream = Files.lines(Paths.get(string3, new String[0]), Charset.forName("utf-8"));
            Throwable throwable = null;
            try {
                stream.forEach(string -> {
                    atomicInteger.incrementAndGet();
                    string = string.trim();
                    if (string.length() > 4 || string.length() < 2 || !Utils.isChineseCharAndLengthAtLeastTwo(string) || RecognitionTool.recog(string)) {
                        LOGGER.debug("\u8fc7\u6ee4\uff1a" + string);
                        return;
                    }
                    hashSet.add(string);
                });
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (stream == null) continue;
                if (throwable != null) {
                    try {
                        stream.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                stream.close();
            }
        }
        LOGGER.info("\u5408\u5e76\u8bcd\u6570\uff1a" + atomicInteger.get());
        LOGGER.info("\u4fdd\u7559\u8bcd\u6570\uff1a" + hashSet.size());
        List list2 = hashSet.stream().sorted().collect(Collectors.toList());
        Files.write(Paths.get(string2, new String[0]), (Iterable<? extends CharSequence>)list2, Charset.forName("utf-8"), new OpenOption[0]);
    }
}

