/*
 * Decompiled with CFR 0.152.
 */
package org.apdplat.word.segmentation.impl;

import java.util.List;
import java.util.Map;
import org.apdplat.word.segmentation.SegmentationAlgorithm;
import org.apdplat.word.segmentation.SegmentationFactory;
import org.apdplat.word.segmentation.Word;
import org.apdplat.word.segmentation.impl.AbstractSegmentation;

public class BidirectionalMinimumMatching
extends AbstractSegmentation {
    private static final AbstractSegmentation MIM = (AbstractSegmentation)SegmentationFactory.getSegmentation(SegmentationAlgorithm.MinimumMatching);
    private static final AbstractSegmentation RMIM = (AbstractSegmentation)SegmentationFactory.getSegmentation(SegmentationAlgorithm.ReverseMinimumMatching);

    @Override
    public SegmentationAlgorithm getSegmentationAlgorithm() {
        return SegmentationAlgorithm.BidirectionalMinimumMatching;
    }

    @Override
    public List<Word> segImpl(String string) {
        List<Word> list = RMIM.seg(string);
        if (!this.ngramEnabled()) {
            return list;
        }
        List<Word> list2 = MIM.seg(string);
        if (list.size() == list2.size() && list.equals(list2)) {
            return list;
        }
        Map<List<Word>, Float> map = this.ngram(list, list2);
        float f = map.get(list).floatValue();
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug("\u9006\u5411\u6700\u5c0f\u5339\u914d\uff1a" + list.toString() + " : ngram\u5206\u503c=" + f);
        }
        List<Word> list3 = list;
        float f2 = f;
        f = map.get(list2).floatValue();
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug("\u6b63\u5411\u6700\u5c0f\u5339\u914d\uff1a" + list2.toString() + " : ngram\u5206\u503c=" + f);
        }
        if (f > f2) {
            list3 = list2;
            f2 = f;
        }
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug("\u6700\u5927\u5206\u503c\uff1a" + f2 + ", \u6d88\u6b67\u7ed3\u679c\uff1a" + list3);
        }
        return list3;
    }

    public static void main(String[] stringArray) {
        String string = "\u53e4\u4eba\u5bf9\u4e8e\u5199\u6587\u7ae0\u6709\u4e2a\u57fa\u672c\u8981\u6c42\uff0c\u53eb\u505a\u201c\u6709\u7269\u6709\u5e8f\u201d\u3002\u201c\u6709\u7269\u201d\u5c31\u662f\u8981\u6709\u5185\u5bb9\uff0c\u201c\u6709\u5e8f\u201d\u5c31\u662f\u8981\u6709\u6761\u7406\u3002";
        if (stringArray != null && stringArray.length == 1) {
            string = stringArray[0];
        }
        BidirectionalMinimumMatching bidirectionalMinimumMatching = new BidirectionalMinimumMatching();
        System.out.println(bidirectionalMinimumMatching.seg(string).toString());
    }
}

