/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sasi.memory;

import com.carrotsearch.hppc.LongHashSet;
import com.carrotsearch.hppc.LongSet;
import com.google.common.collect.PeekingIterator;
import java.io.IOException;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentSkipListSet;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.index.sasi.disk.Token;
import org.apache.cassandra.index.sasi.utils.AbstractIterator;
import org.apache.cassandra.index.sasi.utils.CombinedValue;
import org.apache.cassandra.index.sasi.utils.RangeIterator;

public class KeyRangeIterator
extends RangeIterator<Long, Token> {
    private final DKIterator iterator;

    public KeyRangeIterator(ConcurrentSkipListSet<DecoratedKey> keys, int size) {
        super((Long)keys.first().getToken().getTokenValue(), (Long)keys.last().getToken().getTokenValue(), size);
        this.iterator = new DKIterator(keys.iterator());
    }

    @Override
    protected Token computeNext() {
        return this.iterator.hasNext() ? new DKToken((DecoratedKey)this.iterator.next()) : (Token)this.endOfData();
    }

    @Override
    protected void performSkipTo(Long nextToken) {
        DecoratedKey key;
        while (this.iterator.hasNext() && Long.compare((Long)(key = (DecoratedKey)this.iterator.peek()).getToken().getTokenValue(), nextToken) < 0) {
            this.iterator.next();
        }
    }

    @Override
    public void close() throws IOException {
    }

    private static class DKToken
    extends Token {
        private final SortedSet<DecoratedKey> keys;

        public DKToken(final DecoratedKey key) {
            super((Long)key.getToken().getTokenValue());
            this.keys = new TreeSet<DecoratedKey>(DecoratedKey.comparator){
                {
                    super(x0);
                    this.add(key);
                }
            };
        }

        @Override
        public LongSet getOffsets() {
            LongHashSet offsets = new LongHashSet(4);
            for (DecoratedKey key : this.keys) {
                offsets.add(((Long)key.getToken().getTokenValue()).longValue());
            }
            return offsets;
        }

        @Override
        public void merge(CombinedValue<Long> other) {
            if (!(other instanceof Token)) {
                return;
            }
            Token o = (Token)other;
            assert (o.get().equals(this.token));
            if (o instanceof DKToken) {
                this.keys.addAll(((DKToken)o).keys);
            } else {
                for (DecoratedKey key : o) {
                    this.keys.add(key);
                }
            }
        }

        @Override
        public Iterator<DecoratedKey> iterator() {
            return this.keys.iterator();
        }
    }

    private static class DKIterator
    extends AbstractIterator<DecoratedKey>
    implements PeekingIterator<DecoratedKey> {
        private final Iterator<DecoratedKey> keys;

        public DKIterator(Iterator<DecoratedKey> keys) {
            this.keys = keys;
        }

        @Override
        protected DecoratedKey computeNext() {
            return this.keys.hasNext() ? this.keys.next() : (DecoratedKey)this.endOfData();
        }
    }
}

