/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.io;

import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hugegraph.HugeException;
import org.apache.hugegraph.backend.id.EdgeId;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.backend.id.IdGenerator;
import org.apache.hugegraph.backend.store.Shard;
import org.apache.hugegraph.io.GraphSONSchemaSerializer;
import org.apache.hugegraph.io.HugeGraphIoRegistry;
import org.apache.hugegraph.schema.EdgeLabel;
import org.apache.hugegraph.schema.IndexLabel;
import org.apache.hugegraph.schema.PropertyKey;
import org.apache.hugegraph.schema.VertexLabel;
import org.apache.hugegraph.space.GraphSpace;
import org.apache.hugegraph.space.Service;
import org.apache.hugegraph.structure.HugeEdge;
import org.apache.hugegraph.structure.HugeElement;
import org.apache.hugegraph.structure.HugeProperty;
import org.apache.hugegraph.structure.HugeVertex;
import org.apache.hugegraph.type.define.HugeKeys;
import org.apache.hugegraph.util.Blob;
import org.apache.hugegraph.util.Log;
import org.apache.hugegraph.util.SafeDateUtil;
import org.apache.tinkerpop.gremlin.process.traversal.Path;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.Tree;
import org.apache.tinkerpop.gremlin.structure.io.graphson.GraphSONIo;
import org.apache.tinkerpop.gremlin.structure.io.graphson.TinkerPopJacksonModule;
import org.apache.tinkerpop.shaded.jackson.core.JsonGenerator;
import org.apache.tinkerpop.shaded.jackson.core.JsonParser;
import org.apache.tinkerpop.shaded.jackson.core.JsonToken;
import org.apache.tinkerpop.shaded.jackson.core.type.WritableTypeId;
import org.apache.tinkerpop.shaded.jackson.databind.DeserializationContext;
import org.apache.tinkerpop.shaded.jackson.databind.JsonDeserializer;
import org.apache.tinkerpop.shaded.jackson.databind.JsonSerializer;
import org.apache.tinkerpop.shaded.jackson.databind.SerializerProvider;
import org.apache.tinkerpop.shaded.jackson.databind.deser.std.DateDeserializers;
import org.apache.tinkerpop.shaded.jackson.databind.deser.std.StdDeserializer;
import org.apache.tinkerpop.shaded.jackson.databind.deser.std.UUIDDeserializer;
import org.apache.tinkerpop.shaded.jackson.databind.jsontype.TypeSerializer;
import org.apache.tinkerpop.shaded.jackson.databind.module.SimpleModule;
import org.apache.tinkerpop.shaded.jackson.databind.ser.std.DateSerializer;
import org.apache.tinkerpop.shaded.jackson.databind.ser.std.StdSerializer;
import org.apache.tinkerpop.shaded.jackson.databind.ser.std.UUIDSerializer;
import org.slf4j.Logger;

public class HugeGraphSONModule
extends TinkerPopJacksonModule {
    private static final Logger LOG = Log.logger(HugeGraphSONModule.class);
    private static final long serialVersionUID = 6480426922914059122L;
    private static final String TYPE_NAMESPACE = "hugegraph";
    private static boolean OPTIMIZE_SERIALIZE = true;
    private static final Map<Class, String> TYPE_DEFINITIONS;
    private static final GraphSONSchemaSerializer SCHEMA_SERIALIZER;
    private static final String DF = "yyyy-MM-dd HH:mm:ss.SSS";
    public static final DateFormat DATE_FORMAT;

    public static void register(HugeGraphIoRegistry io) {
        io.register(GraphSONIo.class, null, (Object)new HugeGraphSONModule());
    }

    private HugeGraphSONModule() {
        super(TYPE_NAMESPACE);
        HugeGraphSONModule.registerCommonSerializers((SimpleModule)this);
        HugeGraphSONModule.registerIdSerializers((SimpleModule)this);
        HugeGraphSONModule.registerSchemaSerializers((SimpleModule)this);
        if (OPTIMIZE_SERIALIZE) {
            HugeGraphSONModule.registerGraphSerializers((SimpleModule)this);
        }
        HugeGraphSONModule.registerGraphSpaceSerializers((SimpleModule)this);
        HugeGraphSONModule.registerServiceSerializers((SimpleModule)this);
    }

    public Map<Class, String> getTypeDefinitions() {
        return TYPE_DEFINITIONS;
    }

    public String getTypeNamespace() {
        return TYPE_NAMESPACE;
    }

    public static void registerCommonSerializers(SimpleModule module) {
        module.addSerializer(Optional.class, (JsonSerializer)new OptionalSerializer());
        module.addSerializer(Shard.class, (JsonSerializer)new ShardSerializer());
        module.addSerializer(File.class, (JsonSerializer)new FileSerializer());
        boolean useTimestamp = false;
        module.addSerializer(Date.class, (JsonSerializer)new DateSerializer(Boolean.valueOf(useTimestamp), DATE_FORMAT));
        module.addDeserializer(Date.class, (JsonDeserializer)new DateDeserializers.DateDeserializer(new DateDeserializers.DateDeserializer(), DATE_FORMAT, DF));
        module.addSerializer(UUID.class, (JsonSerializer)new UUIDSerializer());
        module.addDeserializer(UUID.class, (JsonDeserializer)new UUIDDeserializer());
        module.addSerializer(Blob.class, (JsonSerializer)new BlobSerializer());
        module.addDeserializer(Blob.class, (JsonDeserializer)new BlobDeserializer());
    }

    public static void registerIdSerializers(SimpleModule module) {
        module.addSerializer(IdGenerator.StringId.class, new IdSerializer<IdGenerator.StringId>(IdGenerator.StringId.class));
        module.addDeserializer(IdGenerator.StringId.class, new IdDeserializer<IdGenerator.StringId>(IdGenerator.StringId.class));
        module.addSerializer(IdGenerator.LongId.class, new IdSerializer<IdGenerator.LongId>(IdGenerator.LongId.class));
        module.addDeserializer(IdGenerator.LongId.class, new IdDeserializer<IdGenerator.LongId>(IdGenerator.LongId.class));
        module.addSerializer(IdGenerator.UuidId.class, new IdSerializer<IdGenerator.UuidId>(IdGenerator.UuidId.class));
        module.addDeserializer(IdGenerator.UuidId.class, new IdDeserializer<IdGenerator.UuidId>(IdGenerator.UuidId.class));
        module.addSerializer(EdgeId.class, new IdSerializer<EdgeId>(EdgeId.class));
        module.addDeserializer(EdgeId.class, new IdDeserializer<EdgeId>(EdgeId.class));
    }

    public static void registerSchemaSerializers(SimpleModule module) {
        module.addSerializer(PropertyKey.class, (JsonSerializer)new PropertyKeySerializer());
        module.addSerializer(VertexLabel.class, (JsonSerializer)new VertexLabelSerializer());
        module.addSerializer(EdgeLabel.class, (JsonSerializer)new EdgeLabelSerializer());
        module.addSerializer(IndexLabel.class, (JsonSerializer)new IndexLabelSerializer());
    }

    public static void registerGraphSerializers(SimpleModule module) {
        module.addSerializer(HugeVertex.class, (JsonSerializer)new HugeVertexSerializer());
        module.addSerializer(HugeEdge.class, (JsonSerializer)new HugeEdgeSerializer());
        module.addSerializer(Path.class, (JsonSerializer)new PathSerializer());
        module.addSerializer(Tree.class, (JsonSerializer)new TreeSerializer());
    }

    public static void registerGraphSpaceSerializers(SimpleModule module) {
        module.addSerializer(GraphSpace.class, (JsonSerializer)new GraphSpaceSerializer());
        module.addDeserializer(GraphSpace.class, (JsonDeserializer)new GraphSpaceDeserializer());
    }

    public static void registerServiceSerializers(SimpleModule module) {
        module.addSerializer(Service.class, (JsonSerializer)new ServiceSerializer());
        module.addDeserializer(Service.class, (JsonDeserializer)new ServiceDeserializer());
    }

    private static void writeEntry(JsonGenerator jsonGenerator, Map<HugeKeys, Object> schema) throws IOException {
        jsonGenerator.writeStartObject();
        for (Map.Entry<HugeKeys, Object> entry : schema.entrySet()) {
            jsonGenerator.writeFieldName(entry.getKey().string());
            jsonGenerator.writeObject(entry.getValue());
        }
        jsonGenerator.writeEndObject();
    }

    static {
        SCHEMA_SERIALIZER = new GraphSONSchemaSerializer();
        DATE_FORMAT = new SimpleDateFormat(DF);
        TYPE_DEFINITIONS = new ConcurrentHashMap<Class, String>();
        TYPE_DEFINITIONS.put(Optional.class, "Optional");
        TYPE_DEFINITIONS.put(Date.class, "Date");
        TYPE_DEFINITIONS.put(UUID.class, "UUID");
        TYPE_DEFINITIONS.put(IdGenerator.StringId.class, "StringId");
        TYPE_DEFINITIONS.put(IdGenerator.LongId.class, "LongId");
        TYPE_DEFINITIONS.put(EdgeId.class, "EdgeId");
        TYPE_DEFINITIONS.put(PropertyKey.class, "PropertyKey");
        TYPE_DEFINITIONS.put(VertexLabel.class, "VertexLabel");
        TYPE_DEFINITIONS.put(EdgeLabel.class, "EdgeLabel");
        TYPE_DEFINITIONS.put(IndexLabel.class, "IndexLabel");
        TYPE_DEFINITIONS.put(HugeVertex.class, "HugeVertex");
        TYPE_DEFINITIONS.put(Shard.class, "Shard");
        TYPE_DEFINITIONS.put(GraphSpace.class, "GraphSpace");
        TYPE_DEFINITIONS.put(Service.class, "Service");
    }

    private static class BlobDeserializer
    extends StdDeserializer<Blob> {
        public BlobDeserializer() {
            super(Blob.class);
        }

        public Blob deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            byte[] bytes = jsonParser.getBinaryValue();
            return Blob.wrap(bytes);
        }
    }

    private static class BlobSerializer
    extends StdSerializer<Blob> {
        public BlobSerializer() {
            super(Blob.class);
        }

        public void serialize(Blob blob, JsonGenerator jsonGenerator, SerializerProvider provider) throws IOException {
            jsonGenerator.writeBinary(blob.bytes());
        }
    }

    private static class FileSerializer
    extends StdSerializer<File> {
        public FileSerializer() {
            super(File.class);
        }

        public void serialize(File file, JsonGenerator jsonGenerator, SerializerProvider provider) throws IOException {
            jsonGenerator.writeStartObject();
            jsonGenerator.writeStringField("file", file.getName());
            jsonGenerator.writeEndObject();
        }
    }

    private static class ShardSerializer
    extends StdSerializer<Shard> {
        public ShardSerializer() {
            super(Shard.class);
        }

        public void serialize(Shard shard, JsonGenerator jsonGenerator, SerializerProvider provider) throws IOException {
            jsonGenerator.writeStartObject();
            jsonGenerator.writeStringField("start", shard.start());
            jsonGenerator.writeStringField("end", shard.end());
            jsonGenerator.writeNumberField("length", shard.length());
            jsonGenerator.writeEndObject();
        }
    }

    private static class TreeSerializer
    extends StdSerializer<Tree> {
        public TreeSerializer() {
            super(Tree.class);
        }

        public void serialize(Tree tree, JsonGenerator jsonGenerator, SerializerProvider provider) throws IOException {
            jsonGenerator.writeStartArray();
            Set set = tree.entrySet();
            for (Map.Entry entry : set) {
                jsonGenerator.writeStartObject();
                jsonGenerator.writeObjectField("key", entry.getKey());
                jsonGenerator.writeObjectField("value", entry.getValue());
                jsonGenerator.writeEndObject();
            }
            jsonGenerator.writeEndArray();
        }
    }

    private static class PathSerializer
    extends StdSerializer<Path> {
        public PathSerializer() {
            super(Path.class);
        }

        public void serialize(Path path, JsonGenerator jsonGenerator, SerializerProvider provider) throws IOException {
            jsonGenerator.writeStartObject();
            jsonGenerator.writeObjectField("labels", (Object)path.labels());
            jsonGenerator.writeObjectField("objects", (Object)path.objects());
            jsonGenerator.writeEndObject();
        }
    }

    private static class HugeEdgeSerializer
    extends HugeElementSerializer<HugeEdge> {
        public HugeEdgeSerializer() {
            super(HugeEdge.class);
        }

        public void serialize(HugeEdge edge, JsonGenerator generator, SerializerProvider provider) throws IOException {
            edge.forceLoad();
            generator.writeStartObject();
            this.writeIdField("id", edge.id(), generator);
            generator.writeStringField("label", edge.label());
            generator.writeStringField("type", "edge");
            HugeVertex outVertex = (HugeVertex)edge.outVertex();
            HugeVertex inVertex = (HugeVertex)edge.inVertex();
            this.writeIdField("outV", outVertex.id(), generator);
            generator.writeStringField("outVLabel", outVertex.label());
            this.writeIdField("inV", inVertex.id(), generator);
            generator.writeStringField("inVLabel", inVertex.label());
            this.writePropertiesField(edge.getFilledProperties(), generator, provider);
            generator.writeEndObject();
        }

        public void serializeWithType(HugeEdge value, JsonGenerator generator, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
            WritableTypeId typeId = typeSer.typeId((Object)value, JsonToken.VALUE_STRING);
            typeSer.writeTypePrefix(generator, typeId);
            this.serialize(value, generator, provider);
            typeSer.writeTypeSuffix(generator, typeId);
        }
    }

    private static class HugeVertexSerializer
    extends HugeElementSerializer<HugeVertex> {
        public HugeVertexSerializer() {
            super(HugeVertex.class);
        }

        public void serialize(HugeVertex vertex, JsonGenerator generator, SerializerProvider provider) throws IOException {
            vertex.forceLoad();
            generator.writeStartObject();
            this.writeIdField("id", vertex.id(), generator);
            generator.writeStringField("label", vertex.label());
            generator.writeStringField("type", "vertex");
            this.writePropertiesField(vertex.getFilledProperties(), generator, provider);
            generator.writeEndObject();
        }

        public void serializeWithType(HugeVertex value, JsonGenerator generator, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
            WritableTypeId typeId = typeSer.typeId((Object)value, JsonToken.VALUE_STRING);
            typeSer.writeTypePrefix(generator, typeId);
            this.serialize(value, generator, provider);
            typeSer.writeTypeSuffix(generator, typeId);
        }
    }

    protected static abstract class HugeElementSerializer<T extends HugeElement>
    extends StdSerializer<T> {
        public HugeElementSerializer(Class<T> clazz) {
            super(clazz);
        }

        public void writeIdField(String fieldName, Id id, JsonGenerator generator) throws IOException {
            generator.writeFieldName(fieldName);
            if (id.number()) {
                generator.writeNumber(id.asLong());
            } else {
                generator.writeString(id.asString());
            }
        }

        public void writePropertiesField(Collection<HugeProperty<?>> properties, JsonGenerator generator, SerializerProvider provider) throws IOException {
            generator.writeFieldName("properties");
            generator.writeStartObject();
            for (HugeProperty<?> property : properties) {
                String key = property.key();
                Object val = property.value();
                try {
                    generator.writeFieldName(key);
                    if (val != null) {
                        JsonSerializer serializer = provider.findValueSerializer(val.getClass());
                        serializer.serialize(val, generator, provider);
                        continue;
                    }
                    generator.writeNull();
                }
                catch (IOException e) {
                    throw new HugeException("Failed to serialize property(%s: %s) for vertex '%s'", key, val, property.element());
                }
            }
            generator.writeEndObject();
        }
    }

    private static class IndexLabelSerializer
    extends StdSerializer<IndexLabel> {
        public IndexLabelSerializer() {
            super(IndexLabel.class);
        }

        public void serialize(IndexLabel il, JsonGenerator jsonGenerator, SerializerProvider provider) throws IOException {
            HugeGraphSONModule.writeEntry(jsonGenerator, SCHEMA_SERIALIZER.writeIndexLabel(il));
        }
    }

    private static class EdgeLabelSerializer
    extends StdSerializer<EdgeLabel> {
        public EdgeLabelSerializer() {
            super(EdgeLabel.class);
        }

        public void serialize(EdgeLabel el, JsonGenerator jsonGenerator, SerializerProvider provider) throws IOException {
            HugeGraphSONModule.writeEntry(jsonGenerator, SCHEMA_SERIALIZER.writeEdgeLabel(el));
        }
    }

    private static class VertexLabelSerializer
    extends StdSerializer<VertexLabel> {
        public VertexLabelSerializer() {
            super(VertexLabel.class);
        }

        public void serialize(VertexLabel vl, JsonGenerator jsonGenerator, SerializerProvider provider) throws IOException {
            HugeGraphSONModule.writeEntry(jsonGenerator, SCHEMA_SERIALIZER.writeVertexLabel(vl));
        }
    }

    private static class PropertyKeySerializer
    extends StdSerializer<PropertyKey> {
        public PropertyKeySerializer() {
            super(PropertyKey.class);
        }

        public void serialize(PropertyKey pk, JsonGenerator jsonGenerator, SerializerProvider provider) throws IOException {
            HugeGraphSONModule.writeEntry(jsonGenerator, SCHEMA_SERIALIZER.writePropertyKey(pk));
        }
    }

    private static class IdDeserializer<T extends Id>
    extends StdDeserializer<T> {
        public IdDeserializer(Class<T> clazz) {
            super(clazz);
        }

        public T deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            Class clazz = this.handledType();
            if (clazz.equals(IdGenerator.LongId.class)) {
                Number idValue = (Number)ctxt.readValue(jsonParser, Number.class);
                return (T)IdGenerator.of(idValue.longValue());
            }
            if (clazz.equals(IdGenerator.StringId.class)) {
                String idValue = (String)ctxt.readValue(jsonParser, String.class);
                return (T)IdGenerator.of(idValue);
            }
            if (clazz.equals(IdGenerator.UuidId.class)) {
                UUID idValue = (UUID)ctxt.readValue(jsonParser, UUID.class);
                return (T)IdGenerator.of(idValue);
            }
            assert (clazz.equals(EdgeId.class));
            String idValue = (String)ctxt.readValue(jsonParser, String.class);
            return (T)EdgeId.parse(idValue);
        }
    }

    private static class IdSerializer<T extends Id>
    extends StdSerializer<T> {
        public IdSerializer(Class<T> clazz) {
            super(clazz);
        }

        public void serialize(T value, JsonGenerator jsonGenerator, SerializerProvider provider) throws IOException {
            if (value.number()) {
                jsonGenerator.writeNumber(value.asLong());
            } else {
                jsonGenerator.writeString(value.asString());
            }
        }

        public void serializeWithType(T value, JsonGenerator jsonGenerator, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
            WritableTypeId typeId = typeSer.typeId(value, JsonToken.VALUE_STRING);
            typeSer.writeTypePrefix(jsonGenerator, typeId);
            this.serialize(value, jsonGenerator, provider);
            typeSer.writeTypeSuffix(jsonGenerator, typeId);
        }
    }

    private static class ServiceDeserializer
    extends StdDeserializer<Service> {
        public ServiceDeserializer() {
            super(Service.class);
        }

        public Service deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            if (jsonParser.getCurrentToken() != JsonToken.START_OBJECT) {
                throw new HugeException("Invalid start marker");
            }
            String name = null;
            String description = null;
            String type = null;
            String deploymentType = null;
            String status = "UNKNOWN";
            Number count = 0;
            Number running = 0;
            Number cpuLimit = 0;
            Number memoryLimit = 0;
            Number storageLimit = 0;
            String routeType = null;
            Number port = 8080;
            HashSet<String> urls = new HashSet<String>();
            HashSet<String> serverDdsUrls = new HashSet<String>();
            HashSet<String> serverNodePortUrls = new HashSet<String>();
            String serviceId = null;
            String pdServiceId = null;
            String creator = null;
            Date createTime = null;
            Date updateTime = null;
            while (jsonParser.nextToken() != JsonToken.END_OBJECT) {
                String val;
                String urlString;
                String fieldName = jsonParser.getCurrentName();
                jsonParser.nextToken();
                if ("name".equals(fieldName)) {
                    name = jsonParser.getText();
                    continue;
                }
                if ("description".equals(fieldName)) {
                    description = jsonParser.getText();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    type = jsonParser.getText();
                    continue;
                }
                if ("deployment_type".equals(fieldName)) {
                    deploymentType = jsonParser.getText();
                    continue;
                }
                if ("status".equals(fieldName)) {
                    status = jsonParser.getText();
                    continue;
                }
                if ("count".equals(fieldName)) {
                    count = jsonParser.getNumberValue();
                    continue;
                }
                if ("running".equals(fieldName)) {
                    running = jsonParser.getNumberValue();
                    continue;
                }
                if ("cpu_limit".equals(fieldName)) {
                    cpuLimit = jsonParser.getNumberValue();
                    continue;
                }
                if ("memory_limit".equals(fieldName)) {
                    memoryLimit = jsonParser.getNumberValue();
                    continue;
                }
                if ("storage_limit".equals(fieldName)) {
                    storageLimit = jsonParser.getNumberValue();
                    continue;
                }
                if ("route_type".equals(fieldName)) {
                    routeType = jsonParser.getText();
                    continue;
                }
                if ("port".equals(fieldName)) {
                    port = jsonParser.getNumberValue();
                    continue;
                }
                if ("urls".equals(fieldName)) {
                    while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
                        urlString = jsonParser.getText();
                        urls.addAll(Arrays.asList(urlString.split(",")));
                    }
                    continue;
                }
                if ("server_dds_urls".equals(fieldName)) {
                    while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
                        urlString = jsonParser.getText();
                        serverDdsUrls.addAll(Arrays.asList(urlString.split(",")));
                    }
                    continue;
                }
                if ("server_node_port_urls".equals(fieldName)) {
                    while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
                        urlString = jsonParser.getText();
                        serverNodePortUrls.addAll(Arrays.asList(urlString.split(",")));
                    }
                    continue;
                }
                if ("service_id".equals(fieldName)) {
                    serviceId = jsonParser.getText();
                    continue;
                }
                if ("pd_service_id".equals(fieldName)) {
                    pdServiceId = jsonParser.getText();
                    continue;
                }
                if ("creator".equals(fieldName)) {
                    creator = jsonParser.getText();
                    continue;
                }
                if ("create_time".equals(fieldName)) {
                    val = jsonParser.getValueAsString();
                    try {
                        createTime = SafeDateUtil.parse(val, HugeGraphSONModule.DF);
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                        createTime = new Date();
                    }
                    continue;
                }
                if ("update_time".equals(fieldName)) {
                    val = jsonParser.getValueAsString();
                    try {
                        updateTime = SafeDateUtil.parse(val, HugeGraphSONModule.DF);
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                        updateTime = new Date();
                    }
                    continue;
                }
                LOG.error("Deserialize Service", (Throwable)new HugeException("Invalid field %s", fieldName));
            }
            jsonParser.close();
            Service service = new Service(name, creator, description, Service.ServiceType.valueOf(type), Service.DeploymentType.valueOf(deploymentType), (int)count, (int)running, (int)cpuLimit, (int)memoryLimit, (int)storageLimit, routeType, (int)port, (Set<String>)urls);
            service.serverDdsUrls(serverDdsUrls);
            service.serverNodePortUrls(serverNodePortUrls);
            service.status(Service.Status.valueOf(status));
            service.serviceId(serviceId);
            service.pdServiceId(pdServiceId);
            service.createTime(createTime);
            service.updateTime(updateTime);
            return service;
        }
    }

    private static class ServiceSerializer
    extends StdSerializer<Service> {
        public ServiceSerializer() {
            super(Service.class);
        }

        public void serialize(Service service, JsonGenerator jsonGenerator, SerializerProvider provider) throws IOException {
            jsonGenerator.writeStartObject();
            for (Map.Entry<String, Object> entry : service.info().entrySet()) {
                jsonGenerator.writeFieldName(entry.getKey());
                jsonGenerator.writeObject(entry.getValue());
            }
            jsonGenerator.writeEndObject();
        }
    }

    private static class GraphSpaceDeserializer
    extends StdDeserializer<GraphSpace> {
        public GraphSpaceDeserializer() {
            super(GraphSpace.class);
        }

        public GraphSpace deserialize(JsonParser jsonParser, DeserializationContext ctxt) throws IOException {
            if (jsonParser.getCurrentToken() != JsonToken.START_OBJECT) {
                throw new HugeException("Invalid start marker");
            }
            String name = null;
            String nickname = null;
            String description = null;
            Number maxGraphNumber = 0;
            Number maxRoleNumber = 0;
            Number cpuLimit = 0;
            Number memoryLimit = 0;
            Number storageLimit = 0;
            Number computeCpuLimit = 0;
            Number computeMemoryLimit = 0;
            String oltpNamespace = null;
            String olapNamespace = null;
            String storageNamespace = null;
            Number cpuUsed = 0;
            Number memoryUsed = 0;
            Number storageUsed = 0;
            Number graphNumberUsed = 0;
            Number roleNumberUsed = 0;
            Boolean auth = false;
            String operatorImagePath = "";
            String internalAlgorithmImageUrl = "";
            String creator = "anonymous";
            Date create = null;
            Date update = null;
            HashMap<String, Object> configs = new HashMap<String, Object>();
            while (jsonParser.nextToken() != JsonToken.END_OBJECT) {
                String val;
                String fieldName = jsonParser.getCurrentName();
                jsonParser.nextToken();
                if ("name".equals(fieldName)) {
                    name = jsonParser.getText();
                    continue;
                }
                if ("nickname".equals(fieldName)) {
                    nickname = jsonParser.getText();
                    continue;
                }
                if ("description".equals(fieldName)) {
                    description = jsonParser.getText();
                    continue;
                }
                if ("max_graph_number".equals(fieldName)) {
                    maxGraphNumber = jsonParser.getNumberValue();
                    continue;
                }
                if ("max_role_number".equals(fieldName)) {
                    maxRoleNumber = jsonParser.getNumberValue();
                    continue;
                }
                if ("cpu_limit".equals(fieldName)) {
                    cpuLimit = jsonParser.getNumberValue();
                    continue;
                }
                if ("memory_limit".equals(fieldName)) {
                    memoryLimit = jsonParser.getNumberValue();
                    continue;
                }
                if ("compute_cpu_limit".equals(fieldName)) {
                    computeCpuLimit = jsonParser.getNumberValue();
                    continue;
                }
                if ("compute_memory_limit".equals(fieldName)) {
                    computeMemoryLimit = jsonParser.getNumberValue();
                    continue;
                }
                if ("storage_limit".equals(fieldName)) {
                    storageLimit = jsonParser.getNumberValue();
                    continue;
                }
                if ("oltp_namespace".equals(fieldName)) {
                    oltpNamespace = jsonParser.getText();
                    continue;
                }
                if ("olap_namespace".equals(fieldName)) {
                    olapNamespace = jsonParser.getText();
                    continue;
                }
                if ("storage_namespace".equals(fieldName)) {
                    storageNamespace = jsonParser.getText();
                    continue;
                }
                if ("cpu_used".equals(fieldName)) {
                    cpuUsed = jsonParser.getNumberValue();
                    continue;
                }
                if ("memory_used".equals(fieldName)) {
                    memoryUsed = jsonParser.getNumberValue();
                    continue;
                }
                if ("storage_used".equals(fieldName)) {
                    storageUsed = jsonParser.getNumberValue();
                    continue;
                }
                if ("graph_number_used".equals(fieldName)) {
                    graphNumberUsed = jsonParser.getNumberValue();
                    continue;
                }
                if ("role_number_used".equals(fieldName)) {
                    roleNumberUsed = jsonParser.getNumberValue();
                    continue;
                }
                if ("auth".equals(fieldName)) {
                    auth = jsonParser.getBooleanValue();
                    continue;
                }
                if ("operator_image_path".equals(fieldName)) {
                    operatorImagePath = jsonParser.getText();
                    continue;
                }
                if ("internal_algorithm_image_url".equals(fieldName)) {
                    internalAlgorithmImageUrl = jsonParser.getText();
                    continue;
                }
                if ("creator".equals(fieldName)) {
                    creator = jsonParser.getText();
                    continue;
                }
                if ("create_time".equals(fieldName)) {
                    val = jsonParser.getValueAsString();
                    if (val == null) {
                        create = new Date();
                        continue;
                    }
                    try {
                        create = SafeDateUtil.parse(val, HugeGraphSONModule.DF);
                    }
                    catch (ParseException e) {
                        LOG.warn("Failed to parse date: {}", (Object)val, (Object)e);
                        create = new Date();
                    }
                    continue;
                }
                if ("update_time".equals(fieldName)) {
                    val = jsonParser.getValueAsString();
                    if (val == null) {
                        update = new Date();
                        continue;
                    }
                    try {
                        update = SafeDateUtil.parse(val, HugeGraphSONModule.DF);
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                        update = new Date();
                    }
                    continue;
                }
                configs.put(fieldName, jsonParser.getValueAsString());
            }
            jsonParser.close();
            GraphSpace space = new GraphSpace(name, nickname, description, (int)cpuLimit, (int)memoryLimit, (int)storageLimit, (int)maxGraphNumber, (int)maxRoleNumber, oltpNamespace, olapNamespace, storageNamespace, (int)cpuUsed, (int)memoryUsed, (int)storageUsed, (int)graphNumberUsed, (int)roleNumberUsed, auth, creator, (Map<String, Object>)configs);
            space.updateTime(update);
            space.createTime(create);
            space.computeCpuLimit(computeCpuLimit.intValue());
            space.computeMemoryLimit(computeMemoryLimit.intValue());
            space.operatorImagePath(operatorImagePath);
            space.internalAlgorithmImageUrl(internalAlgorithmImageUrl);
            return space;
        }
    }

    private static class GraphSpaceSerializer
    extends StdSerializer<GraphSpace> {
        public GraphSpaceSerializer() {
            super(GraphSpace.class);
        }

        public void serialize(GraphSpace gs, JsonGenerator jsonGenerator, SerializerProvider provider) throws IOException {
            jsonGenerator.writeStartObject();
            for (Map.Entry<String, Object> entry : gs.info().entrySet()) {
                jsonGenerator.writeFieldName(entry.getKey());
                jsonGenerator.writeObject(entry.getValue());
            }
            jsonGenerator.writeEndObject();
        }
    }

    private static class OptionalSerializer
    extends StdSerializer<Optional> {
        public OptionalSerializer() {
            super(Optional.class);
        }

        public void serialize(Optional optional, JsonGenerator jsonGenerator, SerializerProvider provider) throws IOException {
            if (optional.isPresent()) {
                jsonGenerator.writeObject(optional.get());
            } else {
                jsonGenerator.writeObject(null);
            }
        }
    }
}

