/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.memory.consumer.factory;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hugegraph.memory.MemoryManager;
import org.apache.hugegraph.memory.consumer.impl.property.HugeEdgePropertyOffHeap;
import org.apache.hugegraph.memory.consumer.impl.property.HugeVertexPropertyOffHeap;
import org.apache.hugegraph.memory.pool.impl.TaskMemoryPool;
import org.apache.hugegraph.schema.PropertyKey;
import org.apache.hugegraph.structure.HugeEdgeProperty;
import org.apache.hugegraph.structure.HugeElement;
import org.apache.hugegraph.structure.HugeVertexProperty;

public class PropertyFactory<V> {
    private MemoryManager.MemoryMode memoryMode;

    private PropertyFactory() {
    }

    public HugeEdgeProperty<V> newHugeEdgeProperty(HugeElement owner, PropertyKey key, V value) {
        switch (this.memoryMode) {
            case ENABLE_ON_HEAP_MANAGEMENT: 
            case ENABLE_OFF_HEAP_MANAGEMENT: {
                TaskMemoryPool taskMemoryPool = (TaskMemoryPool)MemoryManager.getInstance().getCorrespondingTaskMemoryPool(Thread.currentThread().getName());
                return new HugeEdgePropertyOffHeap<V>(taskMemoryPool.getCurrentWorkingOperatorMemoryPool(), owner, key, value);
            }
        }
        return new HugeEdgeProperty<V>(owner, key, value);
    }

    public HugeVertexProperty<V> newHugeVertexProperty(HugeElement owner, PropertyKey key, V value) {
        switch (this.memoryMode) {
            case ENABLE_ON_HEAP_MANAGEMENT: 
            case ENABLE_OFF_HEAP_MANAGEMENT: {
                TaskMemoryPool taskMemoryPool = (TaskMemoryPool)MemoryManager.getInstance().getCorrespondingTaskMemoryPool(Thread.currentThread().getName());
                return new HugeVertexPropertyOffHeap<V>(taskMemoryPool.getCurrentWorkingOperatorMemoryPool(), owner, key, value);
            }
        }
        return new HugeVertexProperty<V>(owner, key, value);
    }

    public static <T> PropertyFactory<T> getInstance(Class<T> clazz) {
        PropertyFactory instance = PropertyFactoryHolder.FACTORIES_MAP.computeIfAbsent(clazz, k -> new PropertyFactory());
        if (instance.memoryMode == null) {
            instance.memoryMode = MemoryManager.getMemoryMode();
        }
        return instance;
    }

    private static class PropertyFactoryHolder {
        private static final Map<Class<?>, PropertyFactory<?>> FACTORIES_MAP = new ConcurrentHashMap();

        private PropertyFactoryHolder() {
        }
    }
}

