/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.loader.flink;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.ververica.cdc.debezium.DebeziumDeserializationSchema;
import io.debezium.data.Envelope;
import java.util.List;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.util.Collector;
import org.apache.hugegraph.util.Log;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceRecord;
import org.slf4j.Logger;

public class HugeGraphDeserialization
implements DebeziumDeserializationSchema<String> {
    private static final Logger LOG = Log.logger(HugeGraphDeserialization.class);

    public void deserialize(SourceRecord sourceRecord, Collector<String> collector) {
        Struct data;
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode result = mapper.createObjectNode();
        Envelope.Operation operation = Envelope.operationFor((SourceRecord)sourceRecord);
        String op = operation.code();
        Struct value = (Struct)sourceRecord.value();
        switch (operation) {
            case DELETE: {
                data = value.getStruct("before");
                break;
            }
            case CREATE: 
            case READ: 
            case UPDATE: {
                data = value.getStruct("after");
                break;
            }
            default: {
                throw new IllegalArgumentException("The type of `op` should be 'c' 'r' 'u' 'd' only");
            }
        }
        ObjectNode rootNode = mapper.createObjectNode();
        if (data != null) {
            Schema afterSchema = data.schema();
            List afterFields = afterSchema.fields();
            for (Field field : afterFields) {
                Object afterValue = data.get(field);
                rootNode.put(field.name(), afterValue.toString());
            }
        }
        result.set("data", (JsonNode)rootNode);
        result.put("op", op);
        LOG.debug("Loaded data: {}", (Object)result);
        collector.collect((Object)result.toString());
    }

    public TypeInformation<String> getProducedType() {
        return BasicTypeInfo.STRING_TYPE_INFO;
    }
}

