/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.loader.util;

import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hugegraph.driver.HugeClient;
import org.apache.hugegraph.driver.HugeClientBuilder;
import org.apache.hugegraph.driver.factory.PDHugeClientFactory;
import org.apache.hugegraph.exception.ServerException;
import org.apache.hugegraph.loader.exception.LoadException;
import org.apache.hugegraph.loader.executor.LoadOptions;
import org.apache.hugegraph.loader.util.UrlParseUtil;
import org.apache.hugegraph.rest.ClientException;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.Log;
import org.slf4j.Logger;

public final class HugeClientHolder {
    public static final Logger LOG = Log.logger(HugeClientHolder.class);

    public static HugeClient create(LoadOptions options) {
        return HugeClientHolder.create(options, true);
    }

    public static HugeClient create(LoadOptions options, boolean useDirect) {
        if (StringUtils.isNotEmpty((CharSequence)options.pdPeers)) {
            HugeClientHolder.pickHostFromMeta(options);
        }
        boolean useHttps = options.protocol != null && options.protocol.equals("https");
        String address = options.host + ":" + options.port;
        if (!options.host.startsWith("http://") && !options.host.startsWith("https://")) {
            address = useHttps ? "https://" + address : "http://" + address;
        }
        String username = options.username != null ? options.username : options.graph;
        try {
            HugeClientBuilder builder = HugeClient.builder((String)address, (String)options.graphSpace, (String)options.graph).configTimeout(options.timeout).configToken(options.token).configUser(username, options.password).configPool(options.maxConnections, options.maxConnectionsPerRoute);
            if (useHttps) {
                String trustFile;
                if (options.trustStoreFile == null) {
                    String homePath = System.getProperty("loader.home.path");
                    E.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)homePath), (String)"The system property 'loader.home.path' can't be null or empty when enable https protocol", (Object[])new Object[0]);
                    trustFile = Paths.get(homePath, "conf/hugegraph.truststore").toString();
                } else {
                    trustFile = options.trustStoreFile;
                }
                String token = options.trustStoreToken == null ? "hugegraph" : options.trustStoreToken;
                builder.configSSL(trustFile, token);
            }
            return builder.build();
        }
        catch (IllegalStateException e) {
            String message = e.getMessage();
            if (message != null && message.startsWith("The version")) {
                throw new LoadException("The version of hugegraph-client and hugegraph-server don't match", e);
            }
            throw e;
        }
        catch (ServerException e) {
            String message = e.getMessage();
            if (401 == e.status() || message != null && message.startsWith("Authentication")) {
                throw new LoadException("Incorrect username or password", e);
            }
            throw e;
        }
        catch (ClientException e) {
            Throwable cause = e.getCause();
            if (cause == null || cause.getMessage() == null) {
                throw e;
            }
            String message = cause.getMessage();
            if (message.contains("Connection refused")) {
                throw new LoadException("The service %s:%s is unavailable", (Throwable)e, options.host, options.port);
            }
            if (message.contains("java.net.UnknownHostException") || message.contains("Host name may not be null")) {
                throw new LoadException("The host %s is unknown", (Throwable)e, options.host);
            }
            if (message.contains("connect timed out")) {
                throw new LoadException("Connect service %s:%s timeout, please check service is available and network is unobstructed", (Throwable)e, options.host, options.port);
            }
            throw e;
        }
    }

    protected static void pickHostFromMeta(LoadOptions options) {
        PDHugeClientFactory clientFactory = new PDHugeClientFactory(options.pdPeers, options.routeType);
        List urls = clientFactory.getAutoURLs(options.cluster, options.graphSpace, null);
        E.checkState((boolean)CollectionUtils.isNotEmpty((Collection)urls), (String)"No available service!", (Object[])new Object[0]);
        int r = (int)Math.floor(Math.random() * (double)urls.size());
        String url = (String)urls.get(r);
        UrlParseUtil.Host hostInfo = UrlParseUtil.parseHost(url);
        E.checkState((boolean)StringUtils.isNotEmpty((CharSequence)hostInfo.getHost()), (String)"Parse url ({}) from pd meta error", (Object[])new Object[]{url});
        options.host = hostInfo.getHost();
        options.port = hostInfo.getPort();
        if (StringUtils.isNotEmpty((CharSequence)hostInfo.getScheme())) {
            options.protocol = hostInfo.getScheme();
        }
        clientFactory.close();
    }
}

