/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.loader.filter.util;

import java.lang.reflect.Field;
import org.apache.hugegraph.client.RestClient;
import org.apache.hugegraph.driver.HugeClient;
import org.apache.hugegraph.driver.SchemaManager;
import org.apache.hugegraph.loader.exception.LoadException;
import org.apache.hugegraph.loader.executor.LoadOptions;
import org.apache.hugegraph.loader.filter.util.VertexLabelBuilderProxy;
import org.apache.hugegraph.structure.schema.BuilderProxy;
import org.apache.hugegraph.structure.schema.VertexLabel;

public class SchemaManagerProxy
extends SchemaManager {
    private LoadOptions options;

    public SchemaManagerProxy(RestClient client, String graphSpace, String graph, LoadOptions options) {
        super(client, graphSpace, graph);
        this.options = options;
    }

    public static void proxy(HugeClient client, LoadOptions options) {
        try {
            Field clientField = HugeClient.class.getDeclaredField("client");
            clientField.setAccessible(true);
            RestClient restClient = (RestClient)clientField.get(client);
            SchemaManagerProxy schemaManager = new SchemaManagerProxy(restClient, client.getGraphSpaceName(), client.getGraphName(), options);
            Field schemaField = HugeClient.class.getDeclaredField("schema");
            schemaField.setAccessible(true);
            schemaField.set(client, (Object)schemaManager);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new LoadException("create schema proxy fail", e);
        }
    }

    public VertexLabel.Builder vertexLabel(String name) {
        VertexLabelBuilderProxy builder = new VertexLabelBuilderProxy(name, this, this.options);
        BuilderProxy proxy = new BuilderProxy((Object)builder);
        return (VertexLabel.Builder)proxy.proxy();
    }
}

