/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.loader.source;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import org.apache.hugegraph.loader.constant.Constants;
import org.apache.hugegraph.loader.source.InputSource;
import org.apache.hugegraph.loader.source.file.ListFormat;
import org.apache.hugegraph.util.CollectionUtil;
import org.apache.hugegraph.util.E;

public abstract class AbstractSource
implements InputSource {
    @JsonProperty(value="header")
    private String[] header = null;
    @JsonProperty(value="charset")
    private String charset = Constants.CHARSET.name();
    @JsonProperty(value="list_format")
    private ListFormat listFormat = null;

    @Override
    public void check() throws IllegalArgumentException {
        if (this.header != null) {
            E.checkArgument((this.header.length > 0 ? 1 : 0) != 0, (String)"The header can't be empty if it has been customized", (Object[])new Object[0]);
            E.checkArgument((boolean)CollectionUtil.allUnique(Arrays.asList(this.header)), (String)"The header can't contain duplicate columns, but got %s", (Object[])new Object[]{Arrays.toString(this.header)});
        }
    }

    @Override
    public String[] header() {
        return this.header;
    }

    public void header(String[] header) {
        this.header = header;
    }

    public void header(List<String> header) {
        this.header = header.toArray(new String[0]);
    }

    @Override
    public String charset() {
        return this.charset;
    }

    public void charset(Charset charset) {
        this.charset = charset.name();
    }

    public void charset(String charset) {
        this.charset = charset;
    }

    public ListFormat listFormat() {
        return this.listFormat;
    }

    public void listFormat(ListFormat listFormat) {
        this.listFormat = listFormat;
    }
}

