/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.api.auth;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.hugegraph.api.auth.AuthAPI;
import org.apache.hugegraph.client.RestClient;
import org.apache.hugegraph.rest.RestResult;
import org.apache.hugegraph.structure.auth.HugePermission;
import org.apache.hugegraph.structure.auth.UserManager;
import org.apache.hugegraph.structure.constant.HugeType;

public class ManagerAPI
extends AuthAPI {
    public ManagerAPI(RestClient client, String graphSpace) {
        super(client, graphSpace);
    }

    public UserManager create(UserManager userManager) {
        RestResult result = this.client.post(this.path(), userManager);
        return (UserManager)result.readObject(UserManager.class);
    }

    public void delete(String user, HugePermission type, String graphSpace) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("user", user);
        params.put("type", (Object)type);
        params.put("graphspace", graphSpace);
        this.client.delete(this.path(), params);
    }

    public List<String> list(HugePermission type, String graphSpace) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("type", (Object)type);
        params.put("graphspace", graphSpace);
        RestResult result = this.client.get(this.path(), params);
        return result.readList("admins", String.class);
    }

    public boolean checkPermission(HugePermission type, String graphSpace) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("type", (Object)type);
        params.put("graphspace", graphSpace);
        String path = this.path() + "/" + "check";
        RestResult result = this.client.get(path, params);
        return ((Map)result.readObject(Map.class)).getOrDefault("check", false);
    }

    public boolean checkDefaultRole(String graphSpace, String role, String graph) {
        String path = ManagerAPI.joinPath(this.path(), "default");
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("graphspace", graphSpace);
        params.put("role", role);
        if (StringUtils.isNotEmpty((String)graph)) {
            params.put("graph", graph);
        }
        RestResult result = this.client.get(path, params);
        return ((Map)result.readObject(Map.class)).getOrDefault("check", false);
    }

    @Override
    protected String type() {
        return HugeType.MANAGER.string();
    }
}

