/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.driver;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.hugegraph.api.graphs.GraphsAPI;
import org.apache.hugegraph.client.RestClient;
import org.apache.hugegraph.rest.ClientException;
import org.apache.hugegraph.structure.constant.GraphMode;
import org.apache.hugegraph.structure.constant.GraphReadMode;

public class GraphsManager {
    private final GraphsAPI graphsAPI;

    public GraphsManager(RestClient client, String graphSpace) {
        this.graphsAPI = new GraphsAPI(client, graphSpace);
    }

    public Map<String, String> createGraph(String name, String config) {
        return this.graphsAPI.create(name, null, config);
    }

    public Map<String, String> createGraph(String name, File file) {
        String config;
        try {
            config = FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new ClientException("Failed to read config file: %s", new Object[]{file});
        }
        return this.graphsAPI.create(name, null, config);
    }

    public Map<String, String> cloneGraph(String name, String cloneGraphName) {
        return this.graphsAPI.create(name, cloneGraphName, null);
    }

    public Map<String, String> cloneGraph(String name, String cloneGraphName, String configText) {
        return this.graphsAPI.create(name, cloneGraphName, configText);
    }

    public Map<String, String> getGraph(String graph) {
        return this.graphsAPI.get(graph);
    }

    public List<String> listGraph() {
        return this.graphsAPI.list();
    }

    public List<Map<String, Object>> listProfile() {
        return this.graphsAPI.listProfile(null);
    }

    public List<Map<String, Object>> listProfile(String prefix) {
        return this.graphsAPI.listProfile(prefix);
    }

    public Map<String, String> setDefault(String name) {
        return this.graphsAPI.setDefault(name);
    }

    public Map<String, String> unSetDefault(String name) {
        return this.graphsAPI.unSetDefault(name);
    }

    public Map<String, String> getDefault() {
        return this.graphsAPI.getDefault();
    }

    public void clearGraph(String graph, String message) {
        this.graphsAPI.clear(graph, message);
    }

    public void update(String graph, String nickname) {
        this.graphsAPI.update(graph, nickname);
    }

    public void dropGraph(String graph, String message) {
        this.graphsAPI.drop(graph, message);
    }

    public void reload(String graph) {
        this.graphsAPI.reload(graph);
    }

    public void reload() {
        this.graphsAPI.reload();
    }

    public void mode(String graph, GraphMode mode) {
        this.graphsAPI.mode(graph, mode);
    }

    public GraphMode mode(String graph) {
        return this.graphsAPI.mode(graph);
    }

    public void readMode(String graph, GraphReadMode readMode) {
        this.graphsAPI.readMode(graph, readMode);
    }

    public GraphReadMode readMode(String graph) {
        return this.graphsAPI.readMode(graph);
    }

    public String clone(String graph, Map<String, Object> body) {
        return this.graphsAPI.clone(graph, body);
    }
}

